// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The build stage (init-container and container) resources in build pod. */
@Immutable
public final class BuildStageProperties {
    /*
     * The name of this build stage resource.
     */
    @JsonProperty(value = "name", access = JsonProperty.Access.WRITE_ONLY)
    private String name;

    /*
     * The provisioning state of this build stage resource.
     */
    @JsonProperty(value = "status", access = JsonProperty.Access.WRITE_ONLY)
    private KPackBuildStageProvisioningState status;

    /**
     * Get the name property: The name of this build stage resource.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the status property: The provisioning state of this build stage resource.
     *
     * @return the status value.
     */
    public KPackBuildStageProvisioningState status() {
        return this.status;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
