// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for CertificateResourceProvisioningState. */
public final class CertificateResourceProvisioningState
    extends ExpandableStringEnum<CertificateResourceProvisioningState> {
    /** Static value Creating for CertificateResourceProvisioningState. */
    public static final CertificateResourceProvisioningState CREATING = fromString("Creating");

    /** Static value Updating for CertificateResourceProvisioningState. */
    public static final CertificateResourceProvisioningState UPDATING = fromString("Updating");

    /** Static value Succeeded for CertificateResourceProvisioningState. */
    public static final CertificateResourceProvisioningState SUCCEEDED = fromString("Succeeded");

    /** Static value Failed for CertificateResourceProvisioningState. */
    public static final CertificateResourceProvisioningState FAILED = fromString("Failed");

    /** Static value Deleting for CertificateResourceProvisioningState. */
    public static final CertificateResourceProvisioningState DELETING = fromString("Deleting");

    /**
     * Creates or finds a CertificateResourceProvisioningState from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding CertificateResourceProvisioningState.
     */
    @JsonCreator
    public static CertificateResourceProvisioningState fromString(String name) {
        return fromString(name, CertificateResourceProvisioningState.class);
    }

    /**
     * Gets known CertificateResourceProvisioningState values.
     *
     * @return known CertificateResourceProvisioningState values.
     */
    public static Collection<CertificateResourceProvisioningState> values() {
        return values(CertificateResourceProvisioningState.class);
    }
}
