// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Custom container payload. */
@Fluent
public final class CustomContainer {
    /*
     * The name of the registry that contains the container image
     */
    @JsonProperty(value = "server")
    private String server;

    /*
     * Container image of the custom container. This should be in the form of
     * <repository>:<tag> without the server name of the registry
     */
    @JsonProperty(value = "containerImage")
    private String containerImage;

    /*
     * Entrypoint array. Not executed within a shell. The docker image's
     * ENTRYPOINT is used if this is not provided.
     */
    @JsonProperty(value = "command")
    private List<String> command;

    /*
     * Arguments to the entrypoint. The docker image's CMD is used if this is
     * not provided.
     */
    @JsonProperty(value = "args")
    private List<String> args;

    /*
     * Credential of the image registry
     */
    @JsonProperty(value = "imageRegistryCredential")
    private ImageRegistryCredential imageRegistryCredential;

    /*
     * Language framework of the container image uploaded
     */
    @JsonProperty(value = "languageFramework")
    private String languageFramework;

    /**
     * Get the server property: The name of the registry that contains the container image.
     *
     * @return the server value.
     */
    public String server() {
        return this.server;
    }

    /**
     * Set the server property: The name of the registry that contains the container image.
     *
     * @param server the server value to set.
     * @return the CustomContainer object itself.
     */
    public CustomContainer withServer(String server) {
        this.server = server;
        return this;
    }

    /**
     * Get the containerImage property: Container image of the custom container. This should be in the form of
     * &lt;repository&gt;:&lt;tag&gt; without the server name of the registry.
     *
     * @return the containerImage value.
     */
    public String containerImage() {
        return this.containerImage;
    }

    /**
     * Set the containerImage property: Container image of the custom container. This should be in the form of
     * &lt;repository&gt;:&lt;tag&gt; without the server name of the registry.
     *
     * @param containerImage the containerImage value to set.
     * @return the CustomContainer object itself.
     */
    public CustomContainer withContainerImage(String containerImage) {
        this.containerImage = containerImage;
        return this;
    }

    /**
     * Get the command property: Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if
     * this is not provided.
     *
     * @return the command value.
     */
    public List<String> command() {
        return this.command;
    }

    /**
     * Set the command property: Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if
     * this is not provided.
     *
     * @param command the command value to set.
     * @return the CustomContainer object itself.
     */
    public CustomContainer withCommand(List<String> command) {
        this.command = command;
        return this;
    }

    /**
     * Get the args property: Arguments to the entrypoint. The docker image's CMD is used if this is not provided.
     *
     * @return the args value.
     */
    public List<String> args() {
        return this.args;
    }

    /**
     * Set the args property: Arguments to the entrypoint. The docker image's CMD is used if this is not provided.
     *
     * @param args the args value to set.
     * @return the CustomContainer object itself.
     */
    public CustomContainer withArgs(List<String> args) {
        this.args = args;
        return this;
    }

    /**
     * Get the imageRegistryCredential property: Credential of the image registry.
     *
     * @return the imageRegistryCredential value.
     */
    public ImageRegistryCredential imageRegistryCredential() {
        return this.imageRegistryCredential;
    }

    /**
     * Set the imageRegistryCredential property: Credential of the image registry.
     *
     * @param imageRegistryCredential the imageRegistryCredential value to set.
     * @return the CustomContainer object itself.
     */
    public CustomContainer withImageRegistryCredential(ImageRegistryCredential imageRegistryCredential) {
        this.imageRegistryCredential = imageRegistryCredential;
        return this;
    }

    /**
     * Get the languageFramework property: Language framework of the container image uploaded.
     *
     * @return the languageFramework value.
     */
    public String languageFramework() {
        return this.languageFramework;
    }

    /**
     * Set the languageFramework property: Language framework of the container image uploaded.
     *
     * @param languageFramework the languageFramework value to set.
     * @return the CustomContainer object itself.
     */
    public CustomContainer withLanguageFramework(String languageFramework) {
        this.languageFramework = languageFramework;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (imageRegistryCredential() != null) {
            imageRegistryCredential().validate();
        }
    }
}
