// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Custom persistent disk resource payload. */
@Fluent
public final class CustomPersistentDiskResource {
    /*
     * Properties of the custom persistent disk resource payload.
     */
    @JsonProperty(value = "customPersistentDiskProperties")
    private CustomPersistentDiskProperties customPersistentDiskProperties;

    /*
     * The resource id of Azure Spring Apps Storage resource.
     */
    @JsonProperty(value = "storageId", required = true)
    private String storageId;

    /**
     * Get the customPersistentDiskProperties property: Properties of the custom persistent disk resource payload.
     *
     * @return the customPersistentDiskProperties value.
     */
    public CustomPersistentDiskProperties customPersistentDiskProperties() {
        return this.customPersistentDiskProperties;
    }

    /**
     * Set the customPersistentDiskProperties property: Properties of the custom persistent disk resource payload.
     *
     * @param customPersistentDiskProperties the customPersistentDiskProperties value to set.
     * @return the CustomPersistentDiskResource object itself.
     */
    public CustomPersistentDiskResource withCustomPersistentDiskProperties(
        CustomPersistentDiskProperties customPersistentDiskProperties) {
        this.customPersistentDiskProperties = customPersistentDiskProperties;
        return this;
    }

    /**
     * Get the storageId property: The resource id of Azure Spring Apps Storage resource.
     *
     * @return the storageId value.
     */
    public String storageId() {
        return this.storageId;
    }

    /**
     * Set the storageId property: The resource id of Azure Spring Apps Storage resource.
     *
     * @param storageId the storageId value to set.
     * @return the CustomPersistentDiskResource object itself.
     */
    public CustomPersistentDiskResource withStorageId(String storageId) {
        this.storageId = storageId;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (customPersistentDiskProperties() != null) {
            customPersistentDiskProperties().validate();
        }
        if (storageId() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property storageId in model CustomPersistentDiskResource"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(CustomPersistentDiskResource.class);
}
