// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

/** Deployment settings payload. */
@Fluent
public final class DeploymentSettings {
    /*
     * The requested resource quantity for required CPU and Memory. It is
     * recommended that using this field to represent the required CPU and
     * Memory, the old field cpu and memoryInGB will be deprecated later.
     */
    @JsonProperty(value = "resourceRequests")
    private ResourceRequests resourceRequests;

    /*
     * Collection of environment variables
     */
    @JsonProperty(value = "environmentVariables")
    @JsonInclude(value = JsonInclude.Include.NON_NULL, content = JsonInclude.Include.ALWAYS)
    private Map<String, String> environmentVariables;

    /*
     * Collection of addons
     */
    @JsonProperty(value = "addonConfigs")
    @JsonInclude(value = JsonInclude.Include.NON_NULL, content = JsonInclude.Include.ALWAYS)
    private Map<String, Map<String, Object>> addonConfigs;

    /*
     * Periodic probe of App Instance liveness. App Instance will be restarted
     * if the probe fails. More info:
     * https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
     */
    @JsonProperty(value = "livenessProbe")
    private Probe livenessProbe;

    /*
     * Periodic probe of App Instance service readiness. App Instance will be
     * removed from service endpoints if the probe fails. More info:
     * https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
     */
    @JsonProperty(value = "readinessProbe")
    private Probe readinessProbe;

    /*
     * StartupProbe indicates that the App Instance has successfully
     * initialized. If specified, no other probes are executed until this
     * completes successfully. If this probe fails, the Pod will be restarted,
     * just as if the livenessProbe failed. This can be used to provide
     * different probe parameters at the beginning of a App Instance's
     * lifecycle, when it might take a long time to load data or warm a cache,
     * than during steady-state operation. This cannot be updated. More info:
     * https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
     */
    @JsonProperty(value = "startupProbe")
    private Probe startupProbe;

    /*
     * Optional duration in seconds the App Instance needs to terminate
     * gracefully. May be decreased in delete request. Value must be
     * non-negative integer. The value zero indicates stop immediately via the
     * kill signal (no opportunity to shut down). If this value is nil, the
     * default grace period will be used instead. The grace period is the
     * duration in seconds after the processes running in the App Instance are
     * sent a termination signal and the time when the processes are forcibly
     * halted with a kill signal. Set this value longer than the expected
     * cleanup time for your process. Defaults to 90 seconds.
     */
    @JsonProperty(value = "terminationGracePeriodSeconds")
    private Integer terminationGracePeriodSeconds;

    /*
     * Container liveness and readiness probe settings
     */
    @JsonProperty(value = "containerProbeSettings")
    private ContainerProbeSettings containerProbeSettings;

    /**
     * Get the resourceRequests property: The requested resource quantity for required CPU and Memory. It is recommended
     * that using this field to represent the required CPU and Memory, the old field cpu and memoryInGB will be
     * deprecated later.
     *
     * @return the resourceRequests value.
     */
    public ResourceRequests resourceRequests() {
        return this.resourceRequests;
    }

    /**
     * Set the resourceRequests property: The requested resource quantity for required CPU and Memory. It is recommended
     * that using this field to represent the required CPU and Memory, the old field cpu and memoryInGB will be
     * deprecated later.
     *
     * @param resourceRequests the resourceRequests value to set.
     * @return the DeploymentSettings object itself.
     */
    public DeploymentSettings withResourceRequests(ResourceRequests resourceRequests) {
        this.resourceRequests = resourceRequests;
        return this;
    }

    /**
     * Get the environmentVariables property: Collection of environment variables.
     *
     * @return the environmentVariables value.
     */
    public Map<String, String> environmentVariables() {
        return this.environmentVariables;
    }

    /**
     * Set the environmentVariables property: Collection of environment variables.
     *
     * @param environmentVariables the environmentVariables value to set.
     * @return the DeploymentSettings object itself.
     */
    public DeploymentSettings withEnvironmentVariables(Map<String, String> environmentVariables) {
        this.environmentVariables = environmentVariables;
        return this;
    }

    /**
     * Get the addonConfigs property: Collection of addons.
     *
     * @return the addonConfigs value.
     */
    public Map<String, Map<String, Object>> addonConfigs() {
        return this.addonConfigs;
    }

    /**
     * Set the addonConfigs property: Collection of addons.
     *
     * @param addonConfigs the addonConfigs value to set.
     * @return the DeploymentSettings object itself.
     */
    public DeploymentSettings withAddonConfigs(Map<String, Map<String, Object>> addonConfigs) {
        this.addonConfigs = addonConfigs;
        return this;
    }

    /**
     * Get the livenessProbe property: Periodic probe of App Instance liveness. App Instance will be restarted if the
     * probe fails. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes.
     *
     * @return the livenessProbe value.
     */
    public Probe livenessProbe() {
        return this.livenessProbe;
    }

    /**
     * Set the livenessProbe property: Periodic probe of App Instance liveness. App Instance will be restarted if the
     * probe fails. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes.
     *
     * @param livenessProbe the livenessProbe value to set.
     * @return the DeploymentSettings object itself.
     */
    public DeploymentSettings withLivenessProbe(Probe livenessProbe) {
        this.livenessProbe = livenessProbe;
        return this;
    }

    /**
     * Get the readinessProbe property: Periodic probe of App Instance service readiness. App Instance will be removed
     * from service endpoints if the probe fails. More info:
     * https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes.
     *
     * @return the readinessProbe value.
     */
    public Probe readinessProbe() {
        return this.readinessProbe;
    }

    /**
     * Set the readinessProbe property: Periodic probe of App Instance service readiness. App Instance will be removed
     * from service endpoints if the probe fails. More info:
     * https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes.
     *
     * @param readinessProbe the readinessProbe value to set.
     * @return the DeploymentSettings object itself.
     */
    public DeploymentSettings withReadinessProbe(Probe readinessProbe) {
        this.readinessProbe = readinessProbe;
        return this;
    }

    /**
     * Get the startupProbe property: StartupProbe indicates that the App Instance has successfully initialized. If
     * specified, no other probes are executed until this completes successfully. If this probe fails, the Pod will be
     * restarted, just as if the livenessProbe failed. This can be used to provide different probe parameters at the
     * beginning of a App Instance's lifecycle, when it might take a long time to load data or warm a cache, than during
     * steady-state operation. This cannot be updated. More info:
     * https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes.
     *
     * @return the startupProbe value.
     */
    public Probe startupProbe() {
        return this.startupProbe;
    }

    /**
     * Set the startupProbe property: StartupProbe indicates that the App Instance has successfully initialized. If
     * specified, no other probes are executed until this completes successfully. If this probe fails, the Pod will be
     * restarted, just as if the livenessProbe failed. This can be used to provide different probe parameters at the
     * beginning of a App Instance's lifecycle, when it might take a long time to load data or warm a cache, than during
     * steady-state operation. This cannot be updated. More info:
     * https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes.
     *
     * @param startupProbe the startupProbe value to set.
     * @return the DeploymentSettings object itself.
     */
    public DeploymentSettings withStartupProbe(Probe startupProbe) {
        this.startupProbe = startupProbe;
        return this;
    }

    /**
     * Get the terminationGracePeriodSeconds property: Optional duration in seconds the App Instance needs to terminate
     * gracefully. May be decreased in delete request. Value must be non-negative integer. The value zero indicates stop
     * immediately via the kill signal (no opportunity to shut down). If this value is nil, the default grace period
     * will be used instead. The grace period is the duration in seconds after the processes running in the App Instance
     * are sent a termination signal and the time when the processes are forcibly halted with a kill signal. Set this
     * value longer than the expected cleanup time for your process. Defaults to 90 seconds.
     *
     * @return the terminationGracePeriodSeconds value.
     */
    public Integer terminationGracePeriodSeconds() {
        return this.terminationGracePeriodSeconds;
    }

    /**
     * Set the terminationGracePeriodSeconds property: Optional duration in seconds the App Instance needs to terminate
     * gracefully. May be decreased in delete request. Value must be non-negative integer. The value zero indicates stop
     * immediately via the kill signal (no opportunity to shut down). If this value is nil, the default grace period
     * will be used instead. The grace period is the duration in seconds after the processes running in the App Instance
     * are sent a termination signal and the time when the processes are forcibly halted with a kill signal. Set this
     * value longer than the expected cleanup time for your process. Defaults to 90 seconds.
     *
     * @param terminationGracePeriodSeconds the terminationGracePeriodSeconds value to set.
     * @return the DeploymentSettings object itself.
     */
    public DeploymentSettings withTerminationGracePeriodSeconds(Integer terminationGracePeriodSeconds) {
        this.terminationGracePeriodSeconds = terminationGracePeriodSeconds;
        return this;
    }

    /**
     * Get the containerProbeSettings property: Container liveness and readiness probe settings.
     *
     * @return the containerProbeSettings value.
     */
    public ContainerProbeSettings containerProbeSettings() {
        return this.containerProbeSettings;
    }

    /**
     * Set the containerProbeSettings property: Container liveness and readiness probe settings.
     *
     * @param containerProbeSettings the containerProbeSettings value to set.
     * @return the DeploymentSettings object itself.
     */
    public DeploymentSettings withContainerProbeSettings(ContainerProbeSettings containerProbeSettings) {
        this.containerProbeSettings = containerProbeSettings;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (resourceRequests() != null) {
            resourceRequests().validate();
        }
        if (livenessProbe() != null) {
            livenessProbe().validate();
        }
        if (readinessProbe() != null) {
            readinessProbe().validate();
        }
        if (startupProbe() != null) {
            startupProbe().validate();
        }
        if (containerProbeSettings() != null) {
            containerProbeSettings().validate();
        }
    }
}
