// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Diagnostic parameters of diagnostic operations. */
@Fluent
public final class DiagnosticParameters {
    /*
     * App instance name
     */
    @JsonProperty(value = "appInstance")
    private String appInstance;

    /*
     * Your target file path in your own BYOS
     */
    @JsonProperty(value = "filePath")
    private String filePath;

    /*
     * Duration of your JFR. 1 min can be represented by 1m or 60s.
     */
    @JsonProperty(value = "duration")
    private String duration;

    /**
     * Get the appInstance property: App instance name.
     *
     * @return the appInstance value.
     */
    public String appInstance() {
        return this.appInstance;
    }

    /**
     * Set the appInstance property: App instance name.
     *
     * @param appInstance the appInstance value to set.
     * @return the DiagnosticParameters object itself.
     */
    public DiagnosticParameters withAppInstance(String appInstance) {
        this.appInstance = appInstance;
        return this;
    }

    /**
     * Get the filePath property: Your target file path in your own BYOS.
     *
     * @return the filePath value.
     */
    public String filePath() {
        return this.filePath;
    }

    /**
     * Set the filePath property: Your target file path in your own BYOS.
     *
     * @param filePath the filePath value to set.
     * @return the DiagnosticParameters object itself.
     */
    public DiagnosticParameters withFilePath(String filePath) {
        this.filePath = filePath;
        return this;
    }

    /**
     * Get the duration property: Duration of your JFR. 1 min can be represented by 1m or 60s.
     *
     * @return the duration value.
     */
    public String duration() {
        return this.duration;
    }

    /**
     * Set the duration property: Duration of your JFR. 1 min can be represented by 1m or 60s.
     *
     * @param duration the duration value to set.
     * @return the DiagnosticParameters object itself.
     */
    public DiagnosticParameters withDuration(String duration) {
        this.duration = duration;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
