// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;

/** ExecAction describes a "run in container" action. */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "type")
@JsonTypeName("ExecAction")
@Fluent
public final class ExecAction extends ProbeAction {
    /*
     * Command is the command line to execute inside the container, the working
     * directory for the command is root ('/') in the container's filesystem.
     * The command is not run inside a shell, so traditional shell instructions
     * ('|', etc) won't work. To use a shell, you need to explicitly call out
     * to that shell. Exit status of 0 is treated as live/healthy and non-zero
     * is unhealthy.
     */
    @JsonProperty(value = "command")
    private List<String> command;

    /**
     * Get the command property: Command is the command line to execute inside the container, the working directory for
     * the command is root ('/') in the container's filesystem. The command is not run inside a shell, so traditional
     * shell instructions ('|', etc) won't work. To use a shell, you need to explicitly call out to that shell. Exit
     * status of 0 is treated as live/healthy and non-zero is unhealthy.
     *
     * @return the command value.
     */
    public List<String> command() {
        return this.command;
    }

    /**
     * Set the command property: Command is the command line to execute inside the container, the working directory for
     * the command is root ('/') in the container's filesystem. The command is not run inside a shell, so traditional
     * shell instructions ('|', etc) won't work. To use a shell, you need to explicitly call out to that shell. Exit
     * status of 0 is treated as live/healthy and non-zero is unhealthy.
     *
     * @param command the command value to set.
     * @return the ExecAction object itself.
     */
    public ExecAction withCommand(List<String> command) {
        this.command = command;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
