// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Cross-Origin Resource Sharing property. */
@Fluent
public final class GatewayCorsProperties {
    /*
     * Allowed origins to make cross-site requests. The special value `*`
     * allows all domains.
     */
    @JsonProperty(value = "allowedOrigins")
    private List<String> allowedOrigins;

    /*
     * Allowed HTTP methods on cross-site requests. The special value `*`
     * allows all methods. If not set, `GET` and `HEAD` are allowed by default.
     */
    @JsonProperty(value = "allowedMethods")
    private List<String> allowedMethods;

    /*
     * Allowed headers in cross-site requests. The special value `*` allows
     * actual requests to send any header.
     */
    @JsonProperty(value = "allowedHeaders")
    private List<String> allowedHeaders;

    /*
     * How long, in seconds, the response from a pre-flight request can be
     * cached by clients.
     */
    @JsonProperty(value = "maxAge")
    private Integer maxAge;

    /*
     * Whether user credentials are supported on cross-site requests. Valid
     * values: `true`, `false`.
     */
    @JsonProperty(value = "allowCredentials")
    private Boolean allowCredentials;

    /*
     * HTTP response headers to expose for cross-site requests.
     */
    @JsonProperty(value = "exposedHeaders")
    private List<String> exposedHeaders;

    /**
     * Get the allowedOrigins property: Allowed origins to make cross-site requests. The special value `*` allows all
     * domains.
     *
     * @return the allowedOrigins value.
     */
    public List<String> allowedOrigins() {
        return this.allowedOrigins;
    }

    /**
     * Set the allowedOrigins property: Allowed origins to make cross-site requests. The special value `*` allows all
     * domains.
     *
     * @param allowedOrigins the allowedOrigins value to set.
     * @return the GatewayCorsProperties object itself.
     */
    public GatewayCorsProperties withAllowedOrigins(List<String> allowedOrigins) {
        this.allowedOrigins = allowedOrigins;
        return this;
    }

    /**
     * Get the allowedMethods property: Allowed HTTP methods on cross-site requests. The special value `*` allows all
     * methods. If not set, `GET` and `HEAD` are allowed by default.
     *
     * @return the allowedMethods value.
     */
    public List<String> allowedMethods() {
        return this.allowedMethods;
    }

    /**
     * Set the allowedMethods property: Allowed HTTP methods on cross-site requests. The special value `*` allows all
     * methods. If not set, `GET` and `HEAD` are allowed by default.
     *
     * @param allowedMethods the allowedMethods value to set.
     * @return the GatewayCorsProperties object itself.
     */
    public GatewayCorsProperties withAllowedMethods(List<String> allowedMethods) {
        this.allowedMethods = allowedMethods;
        return this;
    }

    /**
     * Get the allowedHeaders property: Allowed headers in cross-site requests. The special value `*` allows actual
     * requests to send any header.
     *
     * @return the allowedHeaders value.
     */
    public List<String> allowedHeaders() {
        return this.allowedHeaders;
    }

    /**
     * Set the allowedHeaders property: Allowed headers in cross-site requests. The special value `*` allows actual
     * requests to send any header.
     *
     * @param allowedHeaders the allowedHeaders value to set.
     * @return the GatewayCorsProperties object itself.
     */
    public GatewayCorsProperties withAllowedHeaders(List<String> allowedHeaders) {
        this.allowedHeaders = allowedHeaders;
        return this;
    }

    /**
     * Get the maxAge property: How long, in seconds, the response from a pre-flight request can be cached by clients.
     *
     * @return the maxAge value.
     */
    public Integer maxAge() {
        return this.maxAge;
    }

    /**
     * Set the maxAge property: How long, in seconds, the response from a pre-flight request can be cached by clients.
     *
     * @param maxAge the maxAge value to set.
     * @return the GatewayCorsProperties object itself.
     */
    public GatewayCorsProperties withMaxAge(Integer maxAge) {
        this.maxAge = maxAge;
        return this;
    }

    /**
     * Get the allowCredentials property: Whether user credentials are supported on cross-site requests. Valid values:
     * `true`, `false`.
     *
     * @return the allowCredentials value.
     */
    public Boolean allowCredentials() {
        return this.allowCredentials;
    }

    /**
     * Set the allowCredentials property: Whether user credentials are supported on cross-site requests. Valid values:
     * `true`, `false`.
     *
     * @param allowCredentials the allowCredentials value to set.
     * @return the GatewayCorsProperties object itself.
     */
    public GatewayCorsProperties withAllowCredentials(Boolean allowCredentials) {
        this.allowCredentials = allowCredentials;
        return this;
    }

    /**
     * Get the exposedHeaders property: HTTP response headers to expose for cross-site requests.
     *
     * @return the exposedHeaders value.
     */
    public List<String> exposedHeaders() {
        return this.exposedHeaders;
    }

    /**
     * Set the exposedHeaders property: HTTP response headers to expose for cross-site requests.
     *
     * @param exposedHeaders the exposedHeaders value to set.
     * @return the GatewayCorsProperties object itself.
     */
    public GatewayCorsProperties withExposedHeaders(List<String> exposedHeaders) {
        this.exposedHeaders = exposedHeaders;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
