// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for HttpSchemeType. */
public final class HttpSchemeType extends ExpandableStringEnum<HttpSchemeType> {
    /** Static value HTTP for HttpSchemeType. */
    public static final HttpSchemeType HTTP = fromString("HTTP");

    /** Static value HTTPS for HttpSchemeType. */
    public static final HttpSchemeType HTTPS = fromString("HTTPS");

    /**
     * Creates or finds a HttpSchemeType from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding HttpSchemeType.
     */
    @JsonCreator
    public static HttpSchemeType fromString(String name) {
        return fromString(name, HttpSchemeType.class);
    }

    /**
     * Gets known HttpSchemeType values.
     *
     * @return known HttpSchemeType values.
     */
    public static Collection<HttpSchemeType> values() {
        return values(HttpSchemeType.class);
    }
}
