// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** App ingress settings payload. */
@Fluent
public final class IngressSettings {
    /*
     * Ingress read time out in seconds.
     */
    @JsonProperty(value = "readTimeoutInSeconds")
    private Integer readTimeoutInSeconds;

    /*
     * Ingress send time out in seconds.
     */
    @JsonProperty(value = "sendTimeoutInSeconds")
    private Integer sendTimeoutInSeconds;

    /*
     * Type of the affinity, set this to Cookie to enable session affinity.
     */
    @JsonProperty(value = "sessionAffinity")
    private SessionAffinity sessionAffinity;

    /*
     * Time in seconds until the cookie expires.
     */
    @JsonProperty(value = "sessionCookieMaxAge")
    private Integer sessionCookieMaxAge;

    /*
     * How ingress should communicate with this app backend service.
     */
    @JsonProperty(value = "backendProtocol")
    private BackendProtocol backendProtocol;

    /*
     * Client-Certification Authentication.
     */
    @JsonProperty(value = "clientAuth")
    private IngressSettingsClientAuth clientAuth;

    /**
     * Get the readTimeoutInSeconds property: Ingress read time out in seconds.
     *
     * @return the readTimeoutInSeconds value.
     */
    public Integer readTimeoutInSeconds() {
        return this.readTimeoutInSeconds;
    }

    /**
     * Set the readTimeoutInSeconds property: Ingress read time out in seconds.
     *
     * @param readTimeoutInSeconds the readTimeoutInSeconds value to set.
     * @return the IngressSettings object itself.
     */
    public IngressSettings withReadTimeoutInSeconds(Integer readTimeoutInSeconds) {
        this.readTimeoutInSeconds = readTimeoutInSeconds;
        return this;
    }

    /**
     * Get the sendTimeoutInSeconds property: Ingress send time out in seconds.
     *
     * @return the sendTimeoutInSeconds value.
     */
    public Integer sendTimeoutInSeconds() {
        return this.sendTimeoutInSeconds;
    }

    /**
     * Set the sendTimeoutInSeconds property: Ingress send time out in seconds.
     *
     * @param sendTimeoutInSeconds the sendTimeoutInSeconds value to set.
     * @return the IngressSettings object itself.
     */
    public IngressSettings withSendTimeoutInSeconds(Integer sendTimeoutInSeconds) {
        this.sendTimeoutInSeconds = sendTimeoutInSeconds;
        return this;
    }

    /**
     * Get the sessionAffinity property: Type of the affinity, set this to Cookie to enable session affinity.
     *
     * @return the sessionAffinity value.
     */
    public SessionAffinity sessionAffinity() {
        return this.sessionAffinity;
    }

    /**
     * Set the sessionAffinity property: Type of the affinity, set this to Cookie to enable session affinity.
     *
     * @param sessionAffinity the sessionAffinity value to set.
     * @return the IngressSettings object itself.
     */
    public IngressSettings withSessionAffinity(SessionAffinity sessionAffinity) {
        this.sessionAffinity = sessionAffinity;
        return this;
    }

    /**
     * Get the sessionCookieMaxAge property: Time in seconds until the cookie expires.
     *
     * @return the sessionCookieMaxAge value.
     */
    public Integer sessionCookieMaxAge() {
        return this.sessionCookieMaxAge;
    }

    /**
     * Set the sessionCookieMaxAge property: Time in seconds until the cookie expires.
     *
     * @param sessionCookieMaxAge the sessionCookieMaxAge value to set.
     * @return the IngressSettings object itself.
     */
    public IngressSettings withSessionCookieMaxAge(Integer sessionCookieMaxAge) {
        this.sessionCookieMaxAge = sessionCookieMaxAge;
        return this;
    }

    /**
     * Get the backendProtocol property: How ingress should communicate with this app backend service.
     *
     * @return the backendProtocol value.
     */
    public BackendProtocol backendProtocol() {
        return this.backendProtocol;
    }

    /**
     * Set the backendProtocol property: How ingress should communicate with this app backend service.
     *
     * @param backendProtocol the backendProtocol value to set.
     * @return the IngressSettings object itself.
     */
    public IngressSettings withBackendProtocol(BackendProtocol backendProtocol) {
        this.backendProtocol = backendProtocol;
        return this;
    }

    /**
     * Get the clientAuth property: Client-Certification Authentication.
     *
     * @return the clientAuth value.
     */
    public IngressSettingsClientAuth clientAuth() {
        return this.clientAuth;
    }

    /**
     * Set the clientAuth property: Client-Certification Authentication.
     *
     * @param clientAuth the clientAuth value to set.
     * @return the IngressSettings object itself.
     */
    public IngressSettings withClientAuth(IngressSettingsClientAuth clientAuth) {
        this.clientAuth = clientAuth;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (clientAuth() != null) {
            clientAuth().validate();
        }
    }
}
