// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Probe describes a health check to be performed against an App Instance to determine whether it is alive or ready to
 * receive traffic.
 */
@Fluent
public final class Probe {
    /*
     * The action of the probe.
     */
    @JsonProperty(value = "probeAction")
    private ProbeAction probeAction;

    /*
     * Indicate whether the probe is disabled.
     */
    @JsonProperty(value = "disableProbe", required = true)
    private boolean disableProbe;

    /*
     * Number of seconds after the App Instance has started before probes are
     * initiated. More info:
     * https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
     */
    @JsonProperty(value = "initialDelaySeconds")
    private Integer initialDelaySeconds;

    /*
     * How often (in seconds) to perform the probe. Minimum value is 1.
     */
    @JsonProperty(value = "periodSeconds")
    private Integer periodSeconds;

    /*
     * Number of seconds after which the probe times out. Minimum value is 1.
     */
    @JsonProperty(value = "timeoutSeconds")
    private Integer timeoutSeconds;

    /*
     * Minimum consecutive failures for the probe to be considered failed after
     * having succeeded. Minimum value is 1.
     */
    @JsonProperty(value = "failureThreshold")
    private Integer failureThreshold;

    /*
     * Minimum consecutive successes for the probe to be considered successful
     * after having failed. Must be 1 for liveness and startup. Minimum value
     * is 1.
     */
    @JsonProperty(value = "successThreshold")
    private Integer successThreshold;

    /**
     * Get the probeAction property: The action of the probe.
     *
     * @return the probeAction value.
     */
    public ProbeAction probeAction() {
        return this.probeAction;
    }

    /**
     * Set the probeAction property: The action of the probe.
     *
     * @param probeAction the probeAction value to set.
     * @return the Probe object itself.
     */
    public Probe withProbeAction(ProbeAction probeAction) {
        this.probeAction = probeAction;
        return this;
    }

    /**
     * Get the disableProbe property: Indicate whether the probe is disabled.
     *
     * @return the disableProbe value.
     */
    public boolean disableProbe() {
        return this.disableProbe;
    }

    /**
     * Set the disableProbe property: Indicate whether the probe is disabled.
     *
     * @param disableProbe the disableProbe value to set.
     * @return the Probe object itself.
     */
    public Probe withDisableProbe(boolean disableProbe) {
        this.disableProbe = disableProbe;
        return this;
    }

    /**
     * Get the initialDelaySeconds property: Number of seconds after the App Instance has started before probes are
     * initiated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes.
     *
     * @return the initialDelaySeconds value.
     */
    public Integer initialDelaySeconds() {
        return this.initialDelaySeconds;
    }

    /**
     * Set the initialDelaySeconds property: Number of seconds after the App Instance has started before probes are
     * initiated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes.
     *
     * @param initialDelaySeconds the initialDelaySeconds value to set.
     * @return the Probe object itself.
     */
    public Probe withInitialDelaySeconds(Integer initialDelaySeconds) {
        this.initialDelaySeconds = initialDelaySeconds;
        return this;
    }

    /**
     * Get the periodSeconds property: How often (in seconds) to perform the probe. Minimum value is 1.
     *
     * @return the periodSeconds value.
     */
    public Integer periodSeconds() {
        return this.periodSeconds;
    }

    /**
     * Set the periodSeconds property: How often (in seconds) to perform the probe. Minimum value is 1.
     *
     * @param periodSeconds the periodSeconds value to set.
     * @return the Probe object itself.
     */
    public Probe withPeriodSeconds(Integer periodSeconds) {
        this.periodSeconds = periodSeconds;
        return this;
    }

    /**
     * Get the timeoutSeconds property: Number of seconds after which the probe times out. Minimum value is 1.
     *
     * @return the timeoutSeconds value.
     */
    public Integer timeoutSeconds() {
        return this.timeoutSeconds;
    }

    /**
     * Set the timeoutSeconds property: Number of seconds after which the probe times out. Minimum value is 1.
     *
     * @param timeoutSeconds the timeoutSeconds value to set.
     * @return the Probe object itself.
     */
    public Probe withTimeoutSeconds(Integer timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
        return this;
    }

    /**
     * Get the failureThreshold property: Minimum consecutive failures for the probe to be considered failed after
     * having succeeded. Minimum value is 1.
     *
     * @return the failureThreshold value.
     */
    public Integer failureThreshold() {
        return this.failureThreshold;
    }

    /**
     * Set the failureThreshold property: Minimum consecutive failures for the probe to be considered failed after
     * having succeeded. Minimum value is 1.
     *
     * @param failureThreshold the failureThreshold value to set.
     * @return the Probe object itself.
     */
    public Probe withFailureThreshold(Integer failureThreshold) {
        this.failureThreshold = failureThreshold;
        return this;
    }

    /**
     * Get the successThreshold property: Minimum consecutive successes for the probe to be considered successful after
     * having failed. Must be 1 for liveness and startup. Minimum value is 1.
     *
     * @return the successThreshold value.
     */
    public Integer successThreshold() {
        return this.successThreshold;
    }

    /**
     * Set the successThreshold property: Minimum consecutive successes for the probe to be considered successful after
     * having failed. Must be 1 for liveness and startup. Minimum value is 1.
     *
     * @param successThreshold the successThreshold value to set.
     * @return the Probe object itself.
     */
    public Probe withSuccessThreshold(Integer successThreshold) {
        this.successThreshold = successThreshold;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (probeAction() != null) {
            probeAction().validate();
        }
    }
}
