// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Details of capabilities available to a SKU in specific zones. */
@Fluent
public final class ResourceSkuZoneDetails {
    /*
     * Gets the set of zones that the SKU is available in with the
     * specified capabilities.
     */
    @JsonProperty(value = "name")
    private List<String> name;

    /*
     * Gets a list of capabilities that are available for the SKU in the
     * specified list of zones.
     */
    @JsonProperty(value = "capabilities")
    private List<ResourceSkuCapabilities> capabilities;

    /**
     * Get the name property: Gets the set of zones that the SKU is available in with the specified capabilities.
     *
     * @return the name value.
     */
    public List<String> name() {
        return this.name;
    }

    /**
     * Set the name property: Gets the set of zones that the SKU is available in with the specified capabilities.
     *
     * @param name the name value to set.
     * @return the ResourceSkuZoneDetails object itself.
     */
    public ResourceSkuZoneDetails withName(List<String> name) {
        this.name = name;
        return this;
    }

    /**
     * Get the capabilities property: Gets a list of capabilities that are available for the SKU in the specified list
     * of zones.
     *
     * @return the capabilities value.
     */
    public List<ResourceSkuCapabilities> capabilities() {
        return this.capabilities;
    }

    /**
     * Set the capabilities property: Gets a list of capabilities that are available for the SKU in the specified list
     * of zones.
     *
     * @param capabilities the capabilities value to set.
     * @return the ResourceSkuZoneDetails object itself.
     */
    public ResourceSkuZoneDetails withCapabilities(List<ResourceSkuCapabilities> capabilities) {
        this.capabilities = capabilities;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (capabilities() != null) {
            capabilities().forEach(e -> e.validate());
        }
    }
}
