// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Service Registry properties payload. */
@Immutable
public final class ServiceRegistryProperties {
    /*
     * State of the Service Registry.
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private ServiceRegistryProvisioningState provisioningState;

    /*
     * The requested resource quantity for required CPU and Memory.
     */
    @JsonProperty(value = "resourceRequests", access = JsonProperty.Access.WRITE_ONLY)
    private ServiceRegistryResourceRequests resourceRequests;

    /*
     * Collection of instances belong to Service Registry.
     */
    @JsonProperty(value = "instances", access = JsonProperty.Access.WRITE_ONLY)
    private List<ServiceRegistryInstance> instances;

    /**
     * Get the provisioningState property: State of the Service Registry.
     *
     * @return the provisioningState value.
     */
    public ServiceRegistryProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the resourceRequests property: The requested resource quantity for required CPU and Memory.
     *
     * @return the resourceRequests value.
     */
    public ServiceRegistryResourceRequests resourceRequests() {
        return this.resourceRequests;
    }

    /**
     * Get the instances property: Collection of instances belong to Service Registry.
     *
     * @return the instances value.
     */
    public List<ServiceRegistryInstance> instances() {
        return this.instances;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (resourceRequests() != null) {
            resourceRequests().validate();
        }
        if (instances() != null) {
            instances().forEach(e -> e.validate());
        }
    }
}
