// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Additional Service settings in vnet injection instance. */
@Fluent
public final class ServiceVNetAddons {
    /*
     * Indicates whether the log stream in vnet injection instance could be
     * accessed from internet.
     */
    @JsonProperty(value = "logStreamPublicEndpoint")
    private Boolean logStreamPublicEndpoint;

    /**
     * Get the logStreamPublicEndpoint property: Indicates whether the log stream in vnet injection instance could be
     * accessed from internet.
     *
     * @return the logStreamPublicEndpoint value.
     */
    public Boolean logStreamPublicEndpoint() {
        return this.logStreamPublicEndpoint;
    }

    /**
     * Set the logStreamPublicEndpoint property: Indicates whether the log stream in vnet injection instance could be
     * accessed from internet.
     *
     * @param logStreamPublicEndpoint the logStreamPublicEndpoint value to set.
     * @return the ServiceVNetAddons object itself.
     */
    public ServiceVNetAddons withLogStreamPublicEndpoint(Boolean logStreamPublicEndpoint) {
        this.logStreamPublicEndpoint = logStreamPublicEndpoint;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
