// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.appplatform.fluent.models.BuildpackBindingResourceInner;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in BuildpackBindingsClient.
 */
public interface BuildpackBindingsClient {
    /**
     * Get collection of buildpack bindings under all builders.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of buildpack bindings under all builders as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<BuildpackBindingResourceInner> listForClusterAsync(String resourceGroupName, String serviceName);

    /**
     * Get collection of buildpack bindings under all builders.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of buildpack bindings under all builders as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<BuildpackBindingResourceInner> listForCluster(String resourceGroupName, String serviceName);

    /**
     * Get collection of buildpack bindings under all builders.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of buildpack bindings under all builders as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<BuildpackBindingResourceInner> listForCluster(String resourceGroupName, String serviceName,
        Context context);

    /**
     * Get a buildpack binding by name.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param buildServiceName The name of the build service resource.
     * @param builderName The name of the builder resource.
     * @param buildpackBindingName The name of the Buildpack Binding Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a buildpack binding by name along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<BuildpackBindingResourceInner>> getWithResponseAsync(String resourceGroupName, String serviceName,
        String buildServiceName, String builderName, String buildpackBindingName);

    /**
     * Get a buildpack binding by name.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param buildServiceName The name of the build service resource.
     * @param builderName The name of the builder resource.
     * @param buildpackBindingName The name of the Buildpack Binding Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a buildpack binding by name on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<BuildpackBindingResourceInner> getAsync(String resourceGroupName, String serviceName, String buildServiceName,
        String builderName, String buildpackBindingName);

    /**
     * Get a buildpack binding by name.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param buildServiceName The name of the build service resource.
     * @param builderName The name of the builder resource.
     * @param buildpackBindingName The name of the Buildpack Binding Name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a buildpack binding by name along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<BuildpackBindingResourceInner> getWithResponse(String resourceGroupName, String serviceName,
        String buildServiceName, String builderName, String buildpackBindingName, Context context);

    /**
     * Get a buildpack binding by name.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param buildServiceName The name of the build service resource.
     * @param builderName The name of the builder resource.
     * @param buildpackBindingName The name of the Buildpack Binding Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a buildpack binding by name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    BuildpackBindingResourceInner get(String resourceGroupName, String serviceName, String buildServiceName,
        String builderName, String buildpackBindingName);

    /**
     * Create or update a buildpack binding.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param buildServiceName The name of the build service resource.
     * @param builderName The name of the builder resource.
     * @param buildpackBindingName The name of the Buildpack Binding Name.
     * @param buildpackBinding The target buildpack binding for the create or update operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return buildpack Binding Resource object along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String serviceName,
        String buildServiceName, String builderName, String buildpackBindingName,
        BuildpackBindingResourceInner buildpackBinding);

    /**
     * Create or update a buildpack binding.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param buildServiceName The name of the build service resource.
     * @param builderName The name of the builder resource.
     * @param buildpackBindingName The name of the Buildpack Binding Name.
     * @param buildpackBinding The target buildpack binding for the create or update operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of buildpack Binding Resource object.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<BuildpackBindingResourceInner>, BuildpackBindingResourceInner> beginCreateOrUpdateAsync(
        String resourceGroupName, String serviceName, String buildServiceName, String builderName,
        String buildpackBindingName, BuildpackBindingResourceInner buildpackBinding);

    /**
     * Create or update a buildpack binding.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param buildServiceName The name of the build service resource.
     * @param builderName The name of the builder resource.
     * @param buildpackBindingName The name of the Buildpack Binding Name.
     * @param buildpackBinding The target buildpack binding for the create or update operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of buildpack Binding Resource object.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<BuildpackBindingResourceInner>, BuildpackBindingResourceInner> beginCreateOrUpdate(
        String resourceGroupName, String serviceName, String buildServiceName, String builderName,
        String buildpackBindingName, BuildpackBindingResourceInner buildpackBinding);

    /**
     * Create or update a buildpack binding.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param buildServiceName The name of the build service resource.
     * @param builderName The name of the builder resource.
     * @param buildpackBindingName The name of the Buildpack Binding Name.
     * @param buildpackBinding The target buildpack binding for the create or update operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of buildpack Binding Resource object.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<BuildpackBindingResourceInner>, BuildpackBindingResourceInner> beginCreateOrUpdate(
        String resourceGroupName, String serviceName, String buildServiceName, String builderName,
        String buildpackBindingName, BuildpackBindingResourceInner buildpackBinding, Context context);

    /**
     * Create or update a buildpack binding.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param buildServiceName The name of the build service resource.
     * @param builderName The name of the builder resource.
     * @param buildpackBindingName The name of the Buildpack Binding Name.
     * @param buildpackBinding The target buildpack binding for the create or update operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return buildpack Binding Resource object on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<BuildpackBindingResourceInner> createOrUpdateAsync(String resourceGroupName, String serviceName,
        String buildServiceName, String builderName, String buildpackBindingName,
        BuildpackBindingResourceInner buildpackBinding);

    /**
     * Create or update a buildpack binding.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param buildServiceName The name of the build service resource.
     * @param builderName The name of the builder resource.
     * @param buildpackBindingName The name of the Buildpack Binding Name.
     * @param buildpackBinding The target buildpack binding for the create or update operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return buildpack Binding Resource object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    BuildpackBindingResourceInner createOrUpdate(String resourceGroupName, String serviceName, String buildServiceName,
        String builderName, String buildpackBindingName, BuildpackBindingResourceInner buildpackBinding);

    /**
     * Create or update a buildpack binding.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param buildServiceName The name of the build service resource.
     * @param builderName The name of the builder resource.
     * @param buildpackBindingName The name of the Buildpack Binding Name.
     * @param buildpackBinding The target buildpack binding for the create or update operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return buildpack Binding Resource object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    BuildpackBindingResourceInner createOrUpdate(String resourceGroupName, String serviceName, String buildServiceName,
        String builderName, String buildpackBindingName, BuildpackBindingResourceInner buildpackBinding,
        Context context);

    /**
     * Operation to delete a Buildpack Binding.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param buildServiceName The name of the build service resource.
     * @param builderName The name of the builder resource.
     * @param buildpackBindingName The name of the Buildpack Binding Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String serviceName,
        String buildServiceName, String builderName, String buildpackBindingName);

    /**
     * Operation to delete a Buildpack Binding.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param buildServiceName The name of the build service resource.
     * @param builderName The name of the builder resource.
     * @param buildpackBindingName The name of the Buildpack Binding Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String serviceName,
        String buildServiceName, String builderName, String buildpackBindingName);

    /**
     * Operation to delete a Buildpack Binding.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param buildServiceName The name of the build service resource.
     * @param builderName The name of the builder resource.
     * @param buildpackBindingName The name of the Buildpack Binding Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String serviceName,
        String buildServiceName, String builderName, String buildpackBindingName);

    /**
     * Operation to delete a Buildpack Binding.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param buildServiceName The name of the build service resource.
     * @param builderName The name of the builder resource.
     * @param buildpackBindingName The name of the Buildpack Binding Name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String serviceName,
        String buildServiceName, String builderName, String buildpackBindingName, Context context);

    /**
     * Operation to delete a Buildpack Binding.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param buildServiceName The name of the build service resource.
     * @param builderName The name of the builder resource.
     * @param buildpackBindingName The name of the Buildpack Binding Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String resourceGroupName, String serviceName, String buildServiceName, String builderName,
        String buildpackBindingName);

    /**
     * Operation to delete a Buildpack Binding.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param buildServiceName The name of the build service resource.
     * @param builderName The name of the builder resource.
     * @param buildpackBindingName The name of the Buildpack Binding Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String serviceName, String buildServiceName, String builderName,
        String buildpackBindingName);

    /**
     * Operation to delete a Buildpack Binding.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param buildServiceName The name of the build service resource.
     * @param builderName The name of the builder resource.
     * @param buildpackBindingName The name of the Buildpack Binding Name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String serviceName, String buildServiceName, String builderName,
        String buildpackBindingName, Context context);

    /**
     * Handles requests to list all buildpack bindings in a builder.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param buildServiceName The name of the build service resource.
     * @param builderName The name of the builder resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return object that includes an array of BuildpackBinding resources and a possible link for next set as paginated
     * response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<BuildpackBindingResourceInner> listAsync(String resourceGroupName, String serviceName,
        String buildServiceName, String builderName);

    /**
     * Handles requests to list all buildpack bindings in a builder.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param buildServiceName The name of the build service resource.
     * @param builderName The name of the builder resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return object that includes an array of BuildpackBinding resources and a possible link for next set as paginated
     * response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<BuildpackBindingResourceInner> list(String resourceGroupName, String serviceName,
        String buildServiceName, String builderName);

    /**
     * Handles requests to list all buildpack bindings in a builder.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param buildServiceName The name of the build service resource.
     * @param builderName The name of the builder resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return object that includes an array of BuildpackBinding resources and a possible link for next set as paginated
     * response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<BuildpackBindingResourceInner> list(String resourceGroupName, String serviceName,
        String buildServiceName, String builderName, Context context);
}
