// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.resourcemanager.appplatform.models.ServiceRegistryProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Service Registry resource.
 */
@Fluent
public final class ServiceRegistryResourceInner extends ProxyResource {
    /*
     * Service Registry properties payload
     */
    @JsonProperty(value = "properties")
    private ServiceRegistryProperties properties;

    /*
     * Metadata pertaining to creation and last modification of the resource.
     */
    @JsonProperty(value = "systemData", access = JsonProperty.Access.WRITE_ONLY)
    private SystemData systemData;

    /**
     * Creates an instance of ServiceRegistryResourceInner class.
     */
    public ServiceRegistryResourceInner() {
    }

    /**
     * Get the properties property: Service Registry properties payload.
     * 
     * @return the properties value.
     */
    public ServiceRegistryProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties property: Service Registry properties payload.
     * 
     * @param properties the properties value to set.
     * @return the ServiceRegistryResourceInner object itself.
     */
    public ServiceRegistryResourceInner withProperties(ServiceRegistryProperties properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Get the systemData property: Metadata pertaining to creation and last modification of the resource.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (properties() != null) {
            properties().validate();
        }
    }
}
