// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.appplatform.fluent.BuildServiceAgentPoolsClient;
import com.azure.resourcemanager.appplatform.fluent.models.BuildServiceAgentPoolResourceInner;
import com.azure.resourcemanager.appplatform.models.BuildServiceAgentPoolResourceCollection;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in BuildServiceAgentPoolsClient.
 */
public final class BuildServiceAgentPoolsClientImpl implements BuildServiceAgentPoolsClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final BuildServiceAgentPoolsService service;

    /**
     * The service client containing this operation class.
     */
    private final AppPlatformManagementClientImpl client;

    /**
     * Initializes an instance of BuildServiceAgentPoolsClientImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    BuildServiceAgentPoolsClientImpl(AppPlatformManagementClientImpl client) {
        this.service = RestProxy.create(BuildServiceAgentPoolsService.class, client.getHttpPipeline(),
            client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for AppPlatformManagementClientBuildServiceAgentPools to be used by the
     * proxy service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "AppPlatformManagemen")
    public interface BuildServiceAgentPoolsService {
        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/agentPools")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<BuildServiceAgentPoolResourceCollection>> list(@HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("serviceName") String serviceName,
            @PathParam("buildServiceName") String buildServiceName, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/agentPools/{agentPoolName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<BuildServiceAgentPoolResourceInner>> get(@HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("serviceName") String serviceName,
            @PathParam("buildServiceName") String buildServiceName, @PathParam("agentPoolName") String agentPoolName,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/agentPools/{agentPoolName}")
        @ExpectedResponses({ 200, 201 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> updatePut(@HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("serviceName") String serviceName,
            @PathParam("buildServiceName") String buildServiceName, @PathParam("agentPoolName") String agentPoolName,
            @BodyParam("application/json") BuildServiceAgentPoolResourceInner agentPoolResource,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<BuildServiceAgentPoolResourceCollection>> listNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * List build service agent pool.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param buildServiceName The name of the build service resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return object that includes an array of build service agent pool resources and a possible link for next set
     * along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<BuildServiceAgentPoolResourceInner>> listSinglePageAsync(String resourceGroupName,
        String serviceName, String buildServiceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (buildServiceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter buildServiceName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.list(this.client.getEndpoint(), this.client.getApiVersion(),
                this.client.getSubscriptionId(), resourceGroupName, serviceName, buildServiceName, accept, context))
            .<PagedResponse<BuildServiceAgentPoolResourceInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * List build service agent pool.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param buildServiceName The name of the build service resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return object that includes an array of build service agent pool resources and a possible link for next set
     * along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<BuildServiceAgentPoolResourceInner>> listSinglePageAsync(String resourceGroupName,
        String serviceName, String buildServiceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (buildServiceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter buildServiceName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(),
                resourceGroupName, serviceName, buildServiceName, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * List build service agent pool.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param buildServiceName The name of the build service resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return object that includes an array of build service agent pool resources and a possible link for next set as
     * paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<BuildServiceAgentPoolResourceInner> listAsync(String resourceGroupName, String serviceName,
        String buildServiceName) {
        return new PagedFlux<>(() -> listSinglePageAsync(resourceGroupName, serviceName, buildServiceName),
            nextLink -> listNextSinglePageAsync(nextLink));
    }

    /**
     * List build service agent pool.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param buildServiceName The name of the build service resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return object that includes an array of build service agent pool resources and a possible link for next set as
     * paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<BuildServiceAgentPoolResourceInner> listAsync(String resourceGroupName, String serviceName,
        String buildServiceName, Context context) {
        return new PagedFlux<>(() -> listSinglePageAsync(resourceGroupName, serviceName, buildServiceName, context),
            nextLink -> listNextSinglePageAsync(nextLink, context));
    }

    /**
     * List build service agent pool.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param buildServiceName The name of the build service resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return object that includes an array of build service agent pool resources and a possible link for next set as
     * paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<BuildServiceAgentPoolResourceInner> list(String resourceGroupName, String serviceName,
        String buildServiceName) {
        return new PagedIterable<>(listAsync(resourceGroupName, serviceName, buildServiceName));
    }

    /**
     * List build service agent pool.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param buildServiceName The name of the build service resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return object that includes an array of build service agent pool resources and a possible link for next set as
     * paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<BuildServiceAgentPoolResourceInner> list(String resourceGroupName, String serviceName,
        String buildServiceName, Context context) {
        return new PagedIterable<>(listAsync(resourceGroupName, serviceName, buildServiceName, context));
    }

    /**
     * Get build service agent pool.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param buildServiceName The name of the build service resource.
     * @param agentPoolName The name of the build service agent pool resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return build service agent pool along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BuildServiceAgentPoolResourceInner>> getWithResponseAsync(String resourceGroupName,
        String serviceName, String buildServiceName, String agentPoolName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (buildServiceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter buildServiceName is required and cannot be null."));
        }
        if (agentPoolName == null) {
            return Mono.error(new IllegalArgumentException("Parameter agentPoolName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.get(this.client.getEndpoint(), this.client.getApiVersion(),
                this.client.getSubscriptionId(), resourceGroupName, serviceName, buildServiceName, agentPoolName,
                accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get build service agent pool.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param buildServiceName The name of the build service resource.
     * @param agentPoolName The name of the build service agent pool resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return build service agent pool along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<BuildServiceAgentPoolResourceInner>> getWithResponseAsync(String resourceGroupName,
        String serviceName, String buildServiceName, String agentPoolName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (buildServiceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter buildServiceName is required and cannot be null."));
        }
        if (agentPoolName == null) {
            return Mono.error(new IllegalArgumentException("Parameter agentPoolName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(),
            resourceGroupName, serviceName, buildServiceName, agentPoolName, accept, context);
    }

    /**
     * Get build service agent pool.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param buildServiceName The name of the build service resource.
     * @param agentPoolName The name of the build service agent pool resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return build service agent pool on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<BuildServiceAgentPoolResourceInner> getAsync(String resourceGroupName, String serviceName,
        String buildServiceName, String agentPoolName) {
        return getWithResponseAsync(resourceGroupName, serviceName, buildServiceName, agentPoolName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get build service agent pool.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param buildServiceName The name of the build service resource.
     * @param agentPoolName The name of the build service agent pool resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return build service agent pool along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BuildServiceAgentPoolResourceInner> getWithResponse(String resourceGroupName, String serviceName,
        String buildServiceName, String agentPoolName, Context context) {
        return getWithResponseAsync(resourceGroupName, serviceName, buildServiceName, agentPoolName, context).block();
    }

    /**
     * Get build service agent pool.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param buildServiceName The name of the build service resource.
     * @param agentPoolName The name of the build service agent pool resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return build service agent pool.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public BuildServiceAgentPoolResourceInner get(String resourceGroupName, String serviceName, String buildServiceName,
        String agentPoolName) {
        return getWithResponse(resourceGroupName, serviceName, buildServiceName, agentPoolName, Context.NONE)
            .getValue();
    }

    /**
     * Create or update build service agent pool.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param buildServiceName The name of the build service resource.
     * @param agentPoolName The name of the build service agent pool resource.
     * @param agentPoolResource Parameters for the update operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the build service agent pool resource along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updatePutWithResponseAsync(String resourceGroupName, String serviceName,
        String buildServiceName, String agentPoolName, BuildServiceAgentPoolResourceInner agentPoolResource) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (buildServiceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter buildServiceName is required and cannot be null."));
        }
        if (agentPoolName == null) {
            return Mono.error(new IllegalArgumentException("Parameter agentPoolName is required and cannot be null."));
        }
        if (agentPoolResource == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter agentPoolResource is required and cannot be null."));
        } else {
            agentPoolResource.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.updatePut(this.client.getEndpoint(), this.client.getApiVersion(),
                this.client.getSubscriptionId(), resourceGroupName, serviceName, buildServiceName, agentPoolName,
                agentPoolResource, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Create or update build service agent pool.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param buildServiceName The name of the build service resource.
     * @param agentPoolName The name of the build service agent pool resource.
     * @param agentPoolResource Parameters for the update operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the build service agent pool resource along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updatePutWithResponseAsync(String resourceGroupName, String serviceName,
        String buildServiceName, String agentPoolName, BuildServiceAgentPoolResourceInner agentPoolResource,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (buildServiceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter buildServiceName is required and cannot be null."));
        }
        if (agentPoolName == null) {
            return Mono.error(new IllegalArgumentException("Parameter agentPoolName is required and cannot be null."));
        }
        if (agentPoolResource == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter agentPoolResource is required and cannot be null."));
        } else {
            agentPoolResource.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.updatePut(this.client.getEndpoint(), this.client.getApiVersion(),
            this.client.getSubscriptionId(), resourceGroupName, serviceName, buildServiceName, agentPoolName,
            agentPoolResource, accept, context);
    }

    /**
     * Create or update build service agent pool.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param buildServiceName The name of the build service resource.
     * @param agentPoolName The name of the build service agent pool resource.
     * @param agentPoolResource Parameters for the update operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of the build service agent pool resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<BuildServiceAgentPoolResourceInner>, BuildServiceAgentPoolResourceInner>
        beginUpdatePutAsync(String resourceGroupName, String serviceName, String buildServiceName, String agentPoolName,
            BuildServiceAgentPoolResourceInner agentPoolResource) {
        Mono<Response<Flux<ByteBuffer>>> mono = updatePutWithResponseAsync(resourceGroupName, serviceName,
            buildServiceName, agentPoolName, agentPoolResource);
        return this.client.<BuildServiceAgentPoolResourceInner, BuildServiceAgentPoolResourceInner>getLroResult(mono,
            this.client.getHttpPipeline(), BuildServiceAgentPoolResourceInner.class,
            BuildServiceAgentPoolResourceInner.class, this.client.getContext());
    }

    /**
     * Create or update build service agent pool.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param buildServiceName The name of the build service resource.
     * @param agentPoolName The name of the build service agent pool resource.
     * @param agentPoolResource Parameters for the update operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of the build service agent pool resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<BuildServiceAgentPoolResourceInner>, BuildServiceAgentPoolResourceInner>
        beginUpdatePutAsync(String resourceGroupName, String serviceName, String buildServiceName, String agentPoolName,
            BuildServiceAgentPoolResourceInner agentPoolResource, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = updatePutWithResponseAsync(resourceGroupName, serviceName,
            buildServiceName, agentPoolName, agentPoolResource, context);
        return this.client.<BuildServiceAgentPoolResourceInner, BuildServiceAgentPoolResourceInner>getLroResult(mono,
            this.client.getHttpPipeline(), BuildServiceAgentPoolResourceInner.class,
            BuildServiceAgentPoolResourceInner.class, context);
    }

    /**
     * Create or update build service agent pool.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param buildServiceName The name of the build service resource.
     * @param agentPoolName The name of the build service agent pool resource.
     * @param agentPoolResource Parameters for the update operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of the build service agent pool resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<BuildServiceAgentPoolResourceInner>, BuildServiceAgentPoolResourceInner>
        beginUpdatePut(String resourceGroupName, String serviceName, String buildServiceName, String agentPoolName,
            BuildServiceAgentPoolResourceInner agentPoolResource) {
        return this
            .beginUpdatePutAsync(resourceGroupName, serviceName, buildServiceName, agentPoolName, agentPoolResource)
            .getSyncPoller();
    }

    /**
     * Create or update build service agent pool.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param buildServiceName The name of the build service resource.
     * @param agentPoolName The name of the build service agent pool resource.
     * @param agentPoolResource Parameters for the update operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of the build service agent pool resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<BuildServiceAgentPoolResourceInner>, BuildServiceAgentPoolResourceInner>
        beginUpdatePut(String resourceGroupName, String serviceName, String buildServiceName, String agentPoolName,
            BuildServiceAgentPoolResourceInner agentPoolResource, Context context) {
        return this.beginUpdatePutAsync(resourceGroupName, serviceName, buildServiceName, agentPoolName,
            agentPoolResource, context).getSyncPoller();
    }

    /**
     * Create or update build service agent pool.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param buildServiceName The name of the build service resource.
     * @param agentPoolName The name of the build service agent pool resource.
     * @param agentPoolResource Parameters for the update operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the build service agent pool resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<BuildServiceAgentPoolResourceInner> updatePutAsync(String resourceGroupName, String serviceName,
        String buildServiceName, String agentPoolName, BuildServiceAgentPoolResourceInner agentPoolResource) {
        return beginUpdatePutAsync(resourceGroupName, serviceName, buildServiceName, agentPoolName, agentPoolResource)
            .last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Create or update build service agent pool.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param buildServiceName The name of the build service resource.
     * @param agentPoolName The name of the build service agent pool resource.
     * @param agentPoolResource Parameters for the update operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the build service agent pool resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<BuildServiceAgentPoolResourceInner> updatePutAsync(String resourceGroupName, String serviceName,
        String buildServiceName, String agentPoolName, BuildServiceAgentPoolResourceInner agentPoolResource,
        Context context) {
        return beginUpdatePutAsync(resourceGroupName, serviceName, buildServiceName, agentPoolName, agentPoolResource,
            context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Create or update build service agent pool.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param buildServiceName The name of the build service resource.
     * @param agentPoolName The name of the build service agent pool resource.
     * @param agentPoolResource Parameters for the update operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the build service agent pool resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public BuildServiceAgentPoolResourceInner updatePut(String resourceGroupName, String serviceName,
        String buildServiceName, String agentPoolName, BuildServiceAgentPoolResourceInner agentPoolResource) {
        return updatePutAsync(resourceGroupName, serviceName, buildServiceName, agentPoolName, agentPoolResource)
            .block();
    }

    /**
     * Create or update build service agent pool.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param buildServiceName The name of the build service resource.
     * @param agentPoolName The name of the build service agent pool resource.
     * @param agentPoolResource Parameters for the update operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the build service agent pool resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public BuildServiceAgentPoolResourceInner updatePut(String resourceGroupName, String serviceName,
        String buildServiceName, String agentPoolName, BuildServiceAgentPoolResourceInner agentPoolResource,
        Context context) {
        return updatePutAsync(resourceGroupName, serviceName, buildServiceName, agentPoolName, agentPoolResource,
            context).block();
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items
     * 
     * The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return object that includes an array of build service agent pool resources and a possible link for next set
     * along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<BuildServiceAgentPoolResourceInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.listNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<BuildServiceAgentPoolResourceInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items
     * 
     * The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return object that includes an array of build service agent pool resources and a possible link for next set
     * along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<BuildServiceAgentPoolResourceInner>> listNextSinglePageAsync(String nextLink,
        Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }
}
