// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * Auth setting for public url.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "authType")
@JsonTypeName("Public")
@Fluent
public final class AcceleratorPublicSetting extends AcceleratorAuthSetting {
    /*
     * Resource Id of CA certificate for https URL of Git repository.
     */
    @JsonProperty(value = "caCertResourceId")
    private String caCertResourceId;

    /**
     * Creates an instance of AcceleratorPublicSetting class.
     */
    public AcceleratorPublicSetting() {
    }

    /**
     * Get the caCertResourceId property: Resource Id of CA certificate for https URL of Git repository.
     * 
     * @return the caCertResourceId value.
     */
    public String caCertResourceId() {
        return this.caCertResourceId;
    }

    /**
     * Set the caCertResourceId property: Resource Id of CA certificate for https URL of Git repository.
     * 
     * @param caCertResourceId the caCertResourceId value to set.
     * @return the AcceleratorPublicSetting object itself.
     */
    public AcceleratorPublicSetting withCaCertResourceId(String caCertResourceId) {
        this.caCertResourceId = caCertResourceId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
