// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

/**
 * Properties of an APM.
 */
@Fluent
public final class ApmProperties {
    /*
     * APM Type
     */
    @JsonProperty(value = "type", required = true)
    private String type;

    /*
     * State of the APM.
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private ApmProvisioningState provisioningState;

    /*
     * Non-sensitive properties for the APM
     */
    @JsonProperty(value = "properties")
    @JsonInclude(value = JsonInclude.Include.NON_NULL, content = JsonInclude.Include.ALWAYS)
    private Map<String, String> properties;

    /*
     * Sensitive properties for the APM
     */
    @JsonProperty(value = "secrets")
    @JsonInclude(value = JsonInclude.Include.NON_NULL, content = JsonInclude.Include.ALWAYS)
    private Map<String, String> secrets;

    /**
     * Creates an instance of ApmProperties class.
     */
    public ApmProperties() {
    }

    /**
     * Get the type property: APM Type.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the type property: APM Type.
     * 
     * @param type the type value to set.
     * @return the ApmProperties object itself.
     */
    public ApmProperties withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Get the provisioningState property: State of the APM.
     * 
     * @return the provisioningState value.
     */
    public ApmProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the properties property: Non-sensitive properties for the APM.
     * 
     * @return the properties value.
     */
    public Map<String, String> properties() {
        return this.properties;
    }

    /**
     * Set the properties property: Non-sensitive properties for the APM.
     * 
     * @param properties the properties value to set.
     * @return the ApmProperties object itself.
     */
    public ApmProperties withProperties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Get the secrets property: Sensitive properties for the APM.
     * 
     * @return the secrets value.
     */
    public Map<String, String> secrets() {
        return this.secrets;
    }

    /**
     * Set the secrets property: Sensitive properties for the APM.
     * 
     * @param secrets the secrets value to set.
     * @return the ApmProperties object itself.
     */
    public ApmProperties withSecrets(Map<String, String> secrets) {
        this.secrets = secrets;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (type() == null) {
            throw LOGGER.logExceptionAsError(
                new IllegalArgumentException("Missing required property type in model ApmProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ApmProperties.class);
}
