// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/**
 * State of the APM.
 */
public final class ApmProvisioningState extends ExpandableStringEnum<ApmProvisioningState> {
    /**
     * Static value Creating for ApmProvisioningState.
     */
    public static final ApmProvisioningState CREATING = fromString("Creating");

    /**
     * Static value Updating for ApmProvisioningState.
     */
    public static final ApmProvisioningState UPDATING = fromString("Updating");

    /**
     * Static value Succeeded for ApmProvisioningState.
     */
    public static final ApmProvisioningState SUCCEEDED = fromString("Succeeded");

    /**
     * Static value Failed for ApmProvisioningState.
     */
    public static final ApmProvisioningState FAILED = fromString("Failed");

    /**
     * Static value Deleting for ApmProvisioningState.
     */
    public static final ApmProvisioningState DELETING = fromString("Deleting");

    /**
     * Static value Canceled for ApmProvisioningState.
     */
    public static final ApmProvisioningState CANCELED = fromString("Canceled");

    /**
     * Creates a new instance of ApmProvisioningState value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public ApmProvisioningState() {
    }

    /**
     * Creates or finds a ApmProvisioningState from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding ApmProvisioningState.
     */
    @JsonCreator
    public static ApmProvisioningState fromString(String name) {
        return fromString(name, ApmProvisioningState.class);
    }

    /**
     * Gets known ApmProvisioningState values.
     * 
     * @return known ApmProvisioningState values.
     */
    public static Collection<ApmProvisioningState> values() {
        return values(ApmProvisioningState.class);
    }
}
