// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The ApplicationAcceleratorResourceRequests model.
 */
@Immutable
public final class ApplicationAcceleratorResourceRequests {
    /*
     * Cpu allocated to each application accelerator component. 1 core can be represented by 1 or 1000m
     */
    @JsonProperty(value = "cpu", access = JsonProperty.Access.WRITE_ONLY)
    private String cpu;

    /*
     * Memory allocated to each application accelerator component. 1 GB can be represented by 1Gi or 1024Mi.
     */
    @JsonProperty(value = "memory", access = JsonProperty.Access.WRITE_ONLY)
    private String memory;

    /*
     * Instance count of the application accelerator component.
     */
    @JsonProperty(value = "instanceCount", access = JsonProperty.Access.WRITE_ONLY)
    private Integer instanceCount;

    /**
     * Creates an instance of ApplicationAcceleratorResourceRequests class.
     */
    public ApplicationAcceleratorResourceRequests() {
    }

    /**
     * Get the cpu property: Cpu allocated to each application accelerator component. 1 core can be represented by 1 or
     * 1000m.
     * 
     * @return the cpu value.
     */
    public String cpu() {
        return this.cpu;
    }

    /**
     * Get the memory property: Memory allocated to each application accelerator component. 1 GB can be represented by
     * 1Gi or 1024Mi.
     * 
     * @return the memory value.
     */
    public String memory() {
        return this.memory;
    }

    /**
     * Get the instanceCount property: Instance count of the application accelerator component.
     * 
     * @return the instanceCount value.
     */
    public Integer instanceCount() {
        return this.instanceCount;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
