// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Application Live View properties payload.
 */
@Immutable
public final class ApplicationLiveViewProperties {
    /*
     * State of the Application Live View.
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private ApplicationLiveViewProvisioningState provisioningState;

    /*
     * Component details of Application Live View
     */
    @JsonProperty(value = "components", access = JsonProperty.Access.WRITE_ONLY)
    private List<ApplicationLiveViewComponent> components;

    /**
     * Creates an instance of ApplicationLiveViewProperties class.
     */
    public ApplicationLiveViewProperties() {
    }

    /**
     * Get the provisioningState property: State of the Application Live View.
     * 
     * @return the provisioningState value.
     */
    public ApplicationLiveViewProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the components property: Component details of Application Live View.
     * 
     * @return the components value.
     */
    public List<ApplicationLiveViewComponent> components() {
        return this.components;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (components() != null) {
            components().forEach(e -> e.validate());
        }
    }
}
