// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Build service agent pool properties.
 */
@Fluent
public final class BuildServiceAgentPoolProperties {
    /*
     * Provisioning state of the build service agent pool
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;

    /*
     * build service agent pool size properties
     */
    @JsonProperty(value = "poolSize")
    private BuildServiceAgentPoolSizeProperties poolSize;

    /**
     * Creates an instance of BuildServiceAgentPoolProperties class.
     */
    public BuildServiceAgentPoolProperties() {
    }

    /**
     * Get the provisioningState property: Provisioning state of the build service agent pool.
     * 
     * @return the provisioningState value.
     */
    public String provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the poolSize property: build service agent pool size properties.
     * 
     * @return the poolSize value.
     */
    public BuildServiceAgentPoolSizeProperties poolSize() {
        return this.poolSize;
    }

    /**
     * Set the poolSize property: build service agent pool size properties.
     * 
     * @param poolSize the poolSize value to set.
     * @return the BuildServiceAgentPoolProperties object itself.
     */
    public BuildServiceAgentPoolProperties withPoolSize(BuildServiceAgentPoolSizeProperties poolSize) {
        this.poolSize = poolSize;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (poolSize() != null) {
            poolSize().validate();
        }
    }
}
