// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * A reference to the certificate.
 */
@Fluent
public final class CertificateReference {
    /*
     * Resource Id of the certificate
     */
    @JsonProperty(value = "resourceId", required = true)
    private String resourceId;

    /**
     * Creates an instance of CertificateReference class.
     */
    public CertificateReference() {
    }

    /**
     * Get the resourceId property: Resource Id of the certificate.
     * 
     * @return the resourceId value.
     */
    public String resourceId() {
        return this.resourceId;
    }

    /**
     * Set the resourceId property: Resource Id of the certificate.
     * 
     * @param resourceId the resourceId value to set.
     * @return the CertificateReference object itself.
     */
    public CertificateReference withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (resourceId() == null) {
            throw LOGGER.logExceptionAsError(
                new IllegalArgumentException("Missing required property resourceId in model CertificateReference"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(CertificateReference.class);
}
