// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Service properties payload.
 */
@Fluent
public final class ClusterResourceProperties {
    /*
     * Provisioning state of the Service
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    /*
     * Network profile of the Service
     */
    @JsonProperty(value = "networkProfile")
    private NetworkProfile networkProfile;

    /*
     * Additional Service settings in vnet injection instance
     */
    @JsonProperty(value = "vnetAddons")
    private ServiceVNetAddons vnetAddons;

    /*
     * Version of the Service
     */
    @JsonProperty(value = "version", access = JsonProperty.Access.WRITE_ONLY)
    private Integer version;

    /*
     * ServiceInstanceEntity Id which uniquely identifies a created resource
     */
    @JsonProperty(value = "serviceId", access = JsonProperty.Access.WRITE_ONLY)
    private String serviceId;

    /*
     * Power state of the Service
     */
    @JsonProperty(value = "powerState", access = JsonProperty.Access.WRITE_ONLY)
    private PowerState powerState;

    /*
     * The zoneRedundant property.
     */
    @JsonProperty(value = "zoneRedundant")
    private Boolean zoneRedundant;

    /*
     * Fully qualified dns name of the service instance
     */
    @JsonProperty(value = "fqdn", access = JsonProperty.Access.WRITE_ONLY)
    private String fqdn;

    /*
     * Purchasing 3rd party product of the Service resource.
     */
    @JsonProperty(value = "marketplaceResource")
    private MarketplaceResource marketplaceResource;

    /**
     * Creates an instance of ClusterResourceProperties class.
     */
    public ClusterResourceProperties() {
    }

    /**
     * Get the provisioningState property: Provisioning state of the Service.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the networkProfile property: Network profile of the Service.
     * 
     * @return the networkProfile value.
     */
    public NetworkProfile networkProfile() {
        return this.networkProfile;
    }

    /**
     * Set the networkProfile property: Network profile of the Service.
     * 
     * @param networkProfile the networkProfile value to set.
     * @return the ClusterResourceProperties object itself.
     */
    public ClusterResourceProperties withNetworkProfile(NetworkProfile networkProfile) {
        this.networkProfile = networkProfile;
        return this;
    }

    /**
     * Get the vnetAddons property: Additional Service settings in vnet injection instance.
     * 
     * @return the vnetAddons value.
     */
    public ServiceVNetAddons vnetAddons() {
        return this.vnetAddons;
    }

    /**
     * Set the vnetAddons property: Additional Service settings in vnet injection instance.
     * 
     * @param vnetAddons the vnetAddons value to set.
     * @return the ClusterResourceProperties object itself.
     */
    public ClusterResourceProperties withVnetAddons(ServiceVNetAddons vnetAddons) {
        this.vnetAddons = vnetAddons;
        return this;
    }

    /**
     * Get the version property: Version of the Service.
     * 
     * @return the version value.
     */
    public Integer version() {
        return this.version;
    }

    /**
     * Get the serviceId property: ServiceInstanceEntity Id which uniquely identifies a created resource.
     * 
     * @return the serviceId value.
     */
    public String serviceId() {
        return this.serviceId;
    }

    /**
     * Get the powerState property: Power state of the Service.
     * 
     * @return the powerState value.
     */
    public PowerState powerState() {
        return this.powerState;
    }

    /**
     * Get the zoneRedundant property: The zoneRedundant property.
     * 
     * @return the zoneRedundant value.
     */
    public Boolean zoneRedundant() {
        return this.zoneRedundant;
    }

    /**
     * Set the zoneRedundant property: The zoneRedundant property.
     * 
     * @param zoneRedundant the zoneRedundant value to set.
     * @return the ClusterResourceProperties object itself.
     */
    public ClusterResourceProperties withZoneRedundant(Boolean zoneRedundant) {
        this.zoneRedundant = zoneRedundant;
        return this;
    }

    /**
     * Get the fqdn property: Fully qualified dns name of the service instance.
     * 
     * @return the fqdn value.
     */
    public String fqdn() {
        return this.fqdn;
    }

    /**
     * Get the marketplaceResource property: Purchasing 3rd party product of the Service resource.
     * 
     * @return the marketplaceResource value.
     */
    public MarketplaceResource marketplaceResource() {
        return this.marketplaceResource;
    }

    /**
     * Set the marketplaceResource property: Purchasing 3rd party product of the Service resource.
     * 
     * @param marketplaceResource the marketplaceResource value to set.
     * @return the ClusterResourceProperties object itself.
     */
    public ClusterResourceProperties withMarketplaceResource(MarketplaceResource marketplaceResource) {
        this.marketplaceResource = marketplaceResource;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (networkProfile() != null) {
            networkProfile().validate();
        }
        if (vnetAddons() != null) {
            vnetAddons().validate();
        }
        if (marketplaceResource() != null) {
            marketplaceResource().validate();
        }
    }
}
