// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * Custom container user source info.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "type")
@JsonTypeName("Container")
@Fluent
public final class CustomContainerUserSourceInfo extends UserSourceInfo {
    /*
     * Custom container payload
     */
    @JsonProperty(value = "customContainer")
    private CustomContainer customContainer;

    /**
     * Creates an instance of CustomContainerUserSourceInfo class.
     */
    public CustomContainerUserSourceInfo() {
    }

    /**
     * Get the customContainer property: Custom container payload.
     * 
     * @return the customContainer value.
     */
    public CustomContainer customContainer() {
        return this.customContainer;
    }

    /**
     * Set the customContainer property: Custom container payload.
     * 
     * @param customContainer the customContainer value to set.
     * @return the CustomContainerUserSourceInfo object itself.
     */
    public CustomContainerUserSourceInfo withCustomContainer(CustomContainer customContainer) {
        this.customContainer = customContainer;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public CustomContainerUserSourceInfo withVersion(String version) {
        super.withVersion(version);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (customContainer() != null) {
            customContainer().validate();
        }
    }
}
