// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.appplatform.fluent.models.CustomDomainResourceInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Collection compose of a custom domain resources list and a possible link for next page.
 */
@Fluent
public final class CustomDomainResourceCollection {
    /*
     * The custom domain resources list.
     */
    @JsonProperty(value = "value")
    private List<CustomDomainResourceInner> value;

    /*
     * The link to next page of custom domain list.
     */
    @JsonProperty(value = "nextLink")
    private String nextLink;

    /**
     * Creates an instance of CustomDomainResourceCollection class.
     */
    public CustomDomainResourceCollection() {
    }

    /**
     * Get the value property: The custom domain resources list.
     * 
     * @return the value value.
     */
    public List<CustomDomainResourceInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The custom domain resources list.
     * 
     * @param value the value value to set.
     * @return the CustomDomainResourceCollection object itself.
     */
    public CustomDomainResourceCollection withValue(List<CustomDomainResourceInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The link to next page of custom domain list.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The link to next page of custom domain list.
     * 
     * @param nextLink the nextLink value to set.
     * @return the CustomDomainResourceCollection object itself.
     */
    public CustomDomainResourceCollection withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
