// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/**
 * State of the Dev Tool Portal.
 */
public final class DevToolPortalProvisioningState extends ExpandableStringEnum<DevToolPortalProvisioningState> {
    /**
     * Static value Creating for DevToolPortalProvisioningState.
     */
    public static final DevToolPortalProvisioningState CREATING = fromString("Creating");

    /**
     * Static value Updating for DevToolPortalProvisioningState.
     */
    public static final DevToolPortalProvisioningState UPDATING = fromString("Updating");

    /**
     * Static value Succeeded for DevToolPortalProvisioningState.
     */
    public static final DevToolPortalProvisioningState SUCCEEDED = fromString("Succeeded");

    /**
     * Static value Failed for DevToolPortalProvisioningState.
     */
    public static final DevToolPortalProvisioningState FAILED = fromString("Failed");

    /**
     * Static value Deleting for DevToolPortalProvisioningState.
     */
    public static final DevToolPortalProvisioningState DELETING = fromString("Deleting");

    /**
     * Static value Canceled for DevToolPortalProvisioningState.
     */
    public static final DevToolPortalProvisioningState CANCELED = fromString("Canceled");

    /**
     * Creates a new instance of DevToolPortalProvisioningState value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public DevToolPortalProvisioningState() {
    }

    /**
     * Creates or finds a DevToolPortalProvisioningState from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding DevToolPortalProvisioningState.
     */
    @JsonCreator
    public static DevToolPortalProvisioningState fromString(String name) {
        return fromString(name, DevToolPortalProvisioningState.class);
    }

    /**
     * Gets known DevToolPortalProvisioningState values.
     * 
     * @return known DevToolPortalProvisioningState values.
     */
    public static Collection<DevToolPortalProvisioningState> values() {
        return values(DevToolPortalProvisioningState.class);
    }
}
