// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Client-Certification Authentication.
 */
@Fluent
public final class GatewayPropertiesClientAuth {
    /*
     * Collection of certificate resource Ids in Azure Spring Apps.
     */
    @JsonProperty(value = "certificates")
    private List<String> certificates;

    /*
     * Whether to enable certificate verification or not
     */
    @JsonProperty(value = "certificateVerification")
    private GatewayCertificateVerification certificateVerification;

    /**
     * Creates an instance of GatewayPropertiesClientAuth class.
     */
    public GatewayPropertiesClientAuth() {
    }

    /**
     * Get the certificates property: Collection of certificate resource Ids in Azure Spring Apps.
     * 
     * @return the certificates value.
     */
    public List<String> certificates() {
        return this.certificates;
    }

    /**
     * Set the certificates property: Collection of certificate resource Ids in Azure Spring Apps.
     * 
     * @param certificates the certificates value to set.
     * @return the GatewayPropertiesClientAuth object itself.
     */
    public GatewayPropertiesClientAuth withCertificates(List<String> certificates) {
        this.certificates = certificates;
        return this;
    }

    /**
     * Get the certificateVerification property: Whether to enable certificate verification or not.
     * 
     * @return the certificateVerification value.
     */
    public GatewayCertificateVerification certificateVerification() {
        return this.certificateVerification;
    }

    /**
     * Set the certificateVerification property: Whether to enable certificate verification or not.
     * 
     * @param certificateVerification the certificateVerification value to set.
     * @return the GatewayPropertiesClientAuth object itself.
     */
    public GatewayPropertiesClientAuth
        withCertificateVerification(GatewayCertificateVerification certificateVerification) {
        this.certificateVerification = certificateVerification;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
