// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

/**
 * Environment variables of Spring Cloud Gateway.
 */
@Fluent
public final class GatewayPropertiesEnvironmentVariables {
    /*
     * Non-sensitive properties
     */
    @JsonProperty(value = "properties")
    @JsonInclude(value = JsonInclude.Include.NON_NULL, content = JsonInclude.Include.ALWAYS)
    private Map<String, String> properties;

    /*
     * Sensitive properties
     */
    @JsonProperty(value = "secrets")
    @JsonInclude(value = JsonInclude.Include.NON_NULL, content = JsonInclude.Include.ALWAYS)
    private Map<String, String> secrets;

    /**
     * Creates an instance of GatewayPropertiesEnvironmentVariables class.
     */
    public GatewayPropertiesEnvironmentVariables() {
    }

    /**
     * Get the properties property: Non-sensitive properties.
     * 
     * @return the properties value.
     */
    public Map<String, String> properties() {
        return this.properties;
    }

    /**
     * Set the properties property: Non-sensitive properties.
     * 
     * @param properties the properties value to set.
     * @return the GatewayPropertiesEnvironmentVariables object itself.
     */
    public GatewayPropertiesEnvironmentVariables withProperties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Get the secrets property: Sensitive properties.
     * 
     * @return the secrets value.
     */
    public Map<String, String> secrets() {
        return this.secrets;
    }

    /**
     * Set the secrets property: Sensitive properties.
     * 
     * @param secrets the secrets value to set.
     * @return the GatewayPropertiesEnvironmentVariables object itself.
     */
    public GatewayPropertiesEnvironmentVariables withSecrets(Map<String, String> secrets) {
        this.secrets = secrets;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
