// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/**
 * Git libraries used to support various repository providers.
 */
public final class GitImplementation extends ExpandableStringEnum<GitImplementation> {
    /**
     * Static value go-git for GitImplementation.
     */
    public static final GitImplementation GO_GIT = fromString("go-git");

    /**
     * Static value libgit2 for GitImplementation.
     */
    public static final GitImplementation LIBGIT2 = fromString("libgit2");

    /**
     * Creates a new instance of GitImplementation value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public GitImplementation() {
    }

    /**
     * Creates or finds a GitImplementation from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding GitImplementation.
     */
    @JsonCreator
    public static GitImplementation fromString(String name) {
        return fromString(name, GitImplementation.class);
    }

    /**
     * Gets known GitImplementation values.
     * 
     * @return known GitImplementation values.
     */
    public static Collection<GitImplementation> values() {
        return values(GitImplementation.class);
    }
}
