// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Loaded certificate payload.
 */
@Fluent
public final class LoadedCertificate {
    /*
     * Resource Id of loaded certificate
     */
    @JsonProperty(value = "resourceId", required = true)
    private String resourceId;

    /*
     * Indicate whether the certificate will be loaded into default trust store, only work for Java runtime.
     */
    @JsonProperty(value = "loadTrustStore")
    private Boolean loadTrustStore;

    /**
     * Creates an instance of LoadedCertificate class.
     */
    public LoadedCertificate() {
    }

    /**
     * Get the resourceId property: Resource Id of loaded certificate.
     * 
     * @return the resourceId value.
     */
    public String resourceId() {
        return this.resourceId;
    }

    /**
     * Set the resourceId property: Resource Id of loaded certificate.
     * 
     * @param resourceId the resourceId value to set.
     * @return the LoadedCertificate object itself.
     */
    public LoadedCertificate withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    /**
     * Get the loadTrustStore property: Indicate whether the certificate will be loaded into default trust store, only
     * work for Java runtime.
     * 
     * @return the loadTrustStore value.
     */
    public Boolean loadTrustStore() {
        return this.loadTrustStore;
    }

    /**
     * Set the loadTrustStore property: Indicate whether the certificate will be loaded into default trust store, only
     * work for Java runtime.
     * 
     * @param loadTrustStore the loadTrustStore value to set.
     * @return the LoadedCertificate object itself.
     */
    public LoadedCertificate withLoadTrustStore(Boolean loadTrustStore) {
        this.loadTrustStore = loadTrustStore;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (resourceId() == null) {
            throw LOGGER.logExceptionAsError(
                new IllegalArgumentException("Missing required property resourceId in model LoadedCertificate"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(LoadedCertificate.class);
}
