// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.appplatform.fluent.models.StorageResourceInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Collection compose of storage resources list and a possible link for next page.
 */
@Fluent
public final class StorageResourceCollection {
    /*
     * The storage resources list.
     */
    @JsonProperty(value = "value")
    private List<StorageResourceInner> value;

    /*
     * The link to next page of storage list.
     */
    @JsonProperty(value = "nextLink")
    private String nextLink;

    /**
     * Creates an instance of StorageResourceCollection class.
     */
    public StorageResourceCollection() {
    }

    /**
     * Get the value property: The storage resources list.
     * 
     * @return the value value.
     */
    public List<StorageResourceInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The storage resources list.
     * 
     * @param value the value value to set.
     * @return the StorageResourceCollection object itself.
     */
    public StorageResourceCollection withValue(List<StorageResourceInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The link to next page of storage list.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The link to next page of storage list.
     * 
     * @param nextLink the nextLink value to set.
     * @return the StorageResourceCollection object itself.
     */
    public StorageResourceCollection withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
