// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * Uploaded War binary for a deployment.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "type")
@JsonTypeName("War")
@Fluent
public final class WarUploadedUserSourceInfo extends UploadedUserSourceInfo {
    /*
     * Runtime version of the war file
     */
    @JsonProperty(value = "runtimeVersion")
    private String runtimeVersion;

    /*
     * JVM parameter
     */
    @JsonProperty(value = "jvmOptions")
    private String jvmOptions;

    /*
     * Server version, currently only Apache Tomcat is supported
     */
    @JsonProperty(value = "serverVersion")
    private String serverVersion;

    /**
     * Creates an instance of WarUploadedUserSourceInfo class.
     */
    public WarUploadedUserSourceInfo() {
    }

    /**
     * Get the runtimeVersion property: Runtime version of the war file.
     * 
     * @return the runtimeVersion value.
     */
    public String runtimeVersion() {
        return this.runtimeVersion;
    }

    /**
     * Set the runtimeVersion property: Runtime version of the war file.
     * 
     * @param runtimeVersion the runtimeVersion value to set.
     * @return the WarUploadedUserSourceInfo object itself.
     */
    public WarUploadedUserSourceInfo withRuntimeVersion(String runtimeVersion) {
        this.runtimeVersion = runtimeVersion;
        return this;
    }

    /**
     * Get the jvmOptions property: JVM parameter.
     * 
     * @return the jvmOptions value.
     */
    public String jvmOptions() {
        return this.jvmOptions;
    }

    /**
     * Set the jvmOptions property: JVM parameter.
     * 
     * @param jvmOptions the jvmOptions value to set.
     * @return the WarUploadedUserSourceInfo object itself.
     */
    public WarUploadedUserSourceInfo withJvmOptions(String jvmOptions) {
        this.jvmOptions = jvmOptions;
        return this;
    }

    /**
     * Get the serverVersion property: Server version, currently only Apache Tomcat is supported.
     * 
     * @return the serverVersion value.
     */
    public String serverVersion() {
        return this.serverVersion;
    }

    /**
     * Set the serverVersion property: Server version, currently only Apache Tomcat is supported.
     * 
     * @param serverVersion the serverVersion value to set.
     * @return the WarUploadedUserSourceInfo object itself.
     */
    public WarUploadedUserSourceInfo withServerVersion(String serverVersion) {
        this.serverVersion = serverVersion;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public WarUploadedUserSourceInfo withRelativePath(String relativePath) {
        super.withRelativePath(relativePath);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public WarUploadedUserSourceInfo withVersion(String version) {
        super.withVersion(version);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
