// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Globally enabled APMs payload.
 */
@Fluent
public final class GloballyEnabledApmsInner implements JsonSerializable<GloballyEnabledApmsInner> {
    /*
     * Collection of the globally enabled APMs
     */
    private List<String> value;

    /**
     * Creates an instance of GloballyEnabledApmsInner class.
     */
    public GloballyEnabledApmsInner() {
    }

    /**
     * Get the value property: Collection of the globally enabled APMs.
     * 
     * @return the value value.
     */
    public List<String> value() {
        return this.value;
    }

    /**
     * Set the value property: Collection of the globally enabled APMs.
     * 
     * @param value the value value to set.
     * @return the GloballyEnabledApmsInner object itself.
     */
    public GloballyEnabledApmsInner withValue(List<String> value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GloballyEnabledApmsInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GloballyEnabledApmsInner if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the GloballyEnabledApmsInner.
     */
    public static GloballyEnabledApmsInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GloballyEnabledApmsInner deserializedGloballyEnabledApmsInner = new GloballyEnabledApmsInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<String> value = reader.readArray(reader1 -> reader1.getString());
                    deserializedGloballyEnabledApmsInner.value = value;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGloballyEnabledApmsInner;
        });
    }
}
