// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Config server git properties payload.
 */
@Fluent
public final class ConfigServerProperties implements JsonSerializable<ConfigServerProperties> {
    /*
     * State of the config server.
     */
    private ConfigServerState provisioningState;

    /*
     * Error when apply config server settings.
     */
    private Error error;

    /*
     * Settings of config server.
     */
    private ConfigServerSettings configServer;

    /**
     * Creates an instance of ConfigServerProperties class.
     */
    public ConfigServerProperties() {
    }

    /**
     * Get the provisioningState property: State of the config server.
     * 
     * @return the provisioningState value.
     */
    public ConfigServerState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the error property: Error when apply config server settings.
     * 
     * @return the error value.
     */
    public Error error() {
        return this.error;
    }

    /**
     * Set the error property: Error when apply config server settings.
     * 
     * @param error the error value to set.
     * @return the ConfigServerProperties object itself.
     */
    public ConfigServerProperties withError(Error error) {
        this.error = error;
        return this;
    }

    /**
     * Get the configServer property: Settings of config server.
     * 
     * @return the configServer value.
     */
    public ConfigServerSettings configServer() {
        return this.configServer;
    }

    /**
     * Set the configServer property: Settings of config server.
     * 
     * @param configServer the configServer value to set.
     * @return the ConfigServerProperties object itself.
     */
    public ConfigServerProperties withConfigServer(ConfigServerSettings configServer) {
        this.configServer = configServer;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (error() != null) {
            error().validate();
        }
        if (configServer() != null) {
            configServer().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("error", this.error);
        jsonWriter.writeJsonField("configServer", this.configServer);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ConfigServerProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ConfigServerProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ConfigServerProperties.
     */
    public static ConfigServerProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ConfigServerProperties deserializedConfigServerProperties = new ConfigServerProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("provisioningState".equals(fieldName)) {
                    deserializedConfigServerProperties.provisioningState
                        = ConfigServerState.fromString(reader.getString());
                } else if ("error".equals(fieldName)) {
                    deserializedConfigServerProperties.error = Error.fromJson(reader);
                } else if ("configServer".equals(fieldName)) {
                    deserializedConfigServerProperties.configServer = ConfigServerSettings.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedConfigServerProperties;
        });
    }
}
