// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Validation result for configuration service settings.
 */
@Fluent
public final class ConfigurationServiceGitPropertyValidateResult
    implements JsonSerializable<ConfigurationServiceGitPropertyValidateResult> {
    /*
     * Indicate if the configuration service settings are valid
     */
    private Boolean isValid;

    /*
     * The detail validation results
     */
    private List<ValidationMessages> gitReposValidationResult;

    /**
     * Creates an instance of ConfigurationServiceGitPropertyValidateResult class.
     */
    public ConfigurationServiceGitPropertyValidateResult() {
    }

    /**
     * Get the isValid property: Indicate if the configuration service settings are valid.
     * 
     * @return the isValid value.
     */
    public Boolean isValid() {
        return this.isValid;
    }

    /**
     * Set the isValid property: Indicate if the configuration service settings are valid.
     * 
     * @param isValid the isValid value to set.
     * @return the ConfigurationServiceGitPropertyValidateResult object itself.
     */
    public ConfigurationServiceGitPropertyValidateResult withIsValid(Boolean isValid) {
        this.isValid = isValid;
        return this;
    }

    /**
     * Get the gitReposValidationResult property: The detail validation results.
     * 
     * @return the gitReposValidationResult value.
     */
    public List<ValidationMessages> gitReposValidationResult() {
        return this.gitReposValidationResult;
    }

    /**
     * Set the gitReposValidationResult property: The detail validation results.
     * 
     * @param gitReposValidationResult the gitReposValidationResult value to set.
     * @return the ConfigurationServiceGitPropertyValidateResult object itself.
     */
    public ConfigurationServiceGitPropertyValidateResult
        withGitReposValidationResult(List<ValidationMessages> gitReposValidationResult) {
        this.gitReposValidationResult = gitReposValidationResult;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (gitReposValidationResult() != null) {
            gitReposValidationResult().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("isValid", this.isValid);
        jsonWriter.writeArrayField("gitReposValidationResult", this.gitReposValidationResult,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ConfigurationServiceGitPropertyValidateResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ConfigurationServiceGitPropertyValidateResult if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ConfigurationServiceGitPropertyValidateResult.
     */
    public static ConfigurationServiceGitPropertyValidateResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ConfigurationServiceGitPropertyValidateResult deserializedConfigurationServiceGitPropertyValidateResult
                = new ConfigurationServiceGitPropertyValidateResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("isValid".equals(fieldName)) {
                    deserializedConfigurationServiceGitPropertyValidateResult.isValid
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("gitReposValidationResult".equals(fieldName)) {
                    List<ValidationMessages> gitReposValidationResult
                        = reader.readArray(reader1 -> ValidationMessages.fromJson(reader1));
                    deserializedConfigurationServiceGitPropertyValidateResult.gitReposValidationResult
                        = gitReposValidationResult;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedConfigurationServiceGitPropertyValidateResult;
        });
    }
}
