// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Custom persistent disk resource payload.
 */
@Fluent
public class CustomPersistentDiskProperties implements JsonSerializable<CustomPersistentDiskProperties> {
    /*
     * The type of the underlying resource to mount as a persistent disk.
     */
    private Type type = Type.fromString("CustomPersistentDiskProperties");

    /*
     * The mount path of the persistent disk.
     */
    private String mountPath;

    /*
     * Indicates whether the persistent disk is a readOnly one.
     */
    private Boolean readOnly;

    /*
     * If set to true, it will create and mount a dedicated directory for every individual app instance.
     */
    private Boolean enableSubPath;

    /*
     * These are the mount options for a persistent disk.
     */
    private List<String> mountOptions;

    /**
     * Creates an instance of CustomPersistentDiskProperties class.
     */
    public CustomPersistentDiskProperties() {
    }

    /**
     * Get the type property: The type of the underlying resource to mount as a persistent disk.
     * 
     * @return the type value.
     */
    public Type type() {
        return this.type;
    }

    /**
     * Get the mountPath property: The mount path of the persistent disk.
     * 
     * @return the mountPath value.
     */
    public String mountPath() {
        return this.mountPath;
    }

    /**
     * Set the mountPath property: The mount path of the persistent disk.
     * 
     * @param mountPath the mountPath value to set.
     * @return the CustomPersistentDiskProperties object itself.
     */
    public CustomPersistentDiskProperties withMountPath(String mountPath) {
        this.mountPath = mountPath;
        return this;
    }

    /**
     * Get the readOnly property: Indicates whether the persistent disk is a readOnly one.
     * 
     * @return the readOnly value.
     */
    public Boolean readOnly() {
        return this.readOnly;
    }

    /**
     * Set the readOnly property: Indicates whether the persistent disk is a readOnly one.
     * 
     * @param readOnly the readOnly value to set.
     * @return the CustomPersistentDiskProperties object itself.
     */
    public CustomPersistentDiskProperties withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    /**
     * Get the enableSubPath property: If set to true, it will create and mount a dedicated directory for every
     * individual app instance.
     * 
     * @return the enableSubPath value.
     */
    public Boolean enableSubPath() {
        return this.enableSubPath;
    }

    /**
     * Set the enableSubPath property: If set to true, it will create and mount a dedicated directory for every
     * individual app instance.
     * 
     * @param enableSubPath the enableSubPath value to set.
     * @return the CustomPersistentDiskProperties object itself.
     */
    public CustomPersistentDiskProperties withEnableSubPath(Boolean enableSubPath) {
        this.enableSubPath = enableSubPath;
        return this;
    }

    /**
     * Get the mountOptions property: These are the mount options for a persistent disk.
     * 
     * @return the mountOptions value.
     */
    public List<String> mountOptions() {
        return this.mountOptions;
    }

    /**
     * Set the mountOptions property: These are the mount options for a persistent disk.
     * 
     * @param mountOptions the mountOptions value to set.
     * @return the CustomPersistentDiskProperties object itself.
     */
    public CustomPersistentDiskProperties withMountOptions(List<String> mountOptions) {
        this.mountOptions = mountOptions;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (mountPath() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property mountPath in model CustomPersistentDiskProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(CustomPersistentDiskProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("mountPath", this.mountPath);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeBooleanField("readOnly", this.readOnly);
        jsonWriter.writeBooleanField("enableSubPath", this.enableSubPath);
        jsonWriter.writeArrayField("mountOptions", this.mountOptions, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CustomPersistentDiskProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CustomPersistentDiskProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the CustomPersistentDiskProperties.
     */
    public static CustomPersistentDiskProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject()) {
                readerToUse.nextToken(); // Prepare for reading
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    } else {
                        readerToUse.skipChildren();
                    }
                }
                // Use the discriminator value to determine which subtype should be deserialized.
                if ("AzureFileVolume".equals(discriminatorValue)) {
                    return AzureFileVolume.fromJson(readerToUse.reset());
                } else {
                    return fromJsonKnownDiscriminator(readerToUse.reset());
                }
            }
        });
    }

    static CustomPersistentDiskProperties fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CustomPersistentDiskProperties deserializedCustomPersistentDiskProperties
                = new CustomPersistentDiskProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("mountPath".equals(fieldName)) {
                    deserializedCustomPersistentDiskProperties.mountPath = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedCustomPersistentDiskProperties.type = Type.fromString(reader.getString());
                } else if ("readOnly".equals(fieldName)) {
                    deserializedCustomPersistentDiskProperties.readOnly = reader.getNullable(JsonReader::getBoolean);
                } else if ("enableSubPath".equals(fieldName)) {
                    deserializedCustomPersistentDiskProperties.enableSubPath
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("mountOptions".equals(fieldName)) {
                    List<String> mountOptions = reader.readArray(reader1 -> reader1.getString());
                    deserializedCustomPersistentDiskProperties.mountOptions = mountOptions;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCustomPersistentDiskProperties;
        });
    }
}
