// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Monitoring Setting properties payload.
 */
@Fluent
public final class MonitoringSettingProperties implements JsonSerializable<MonitoringSettingProperties> {
    /*
     * State of the Monitoring Setting.
     */
    private MonitoringSettingState provisioningState;

    /*
     * Error when apply Monitoring Setting changes.
     */
    private Error error;

    /*
     * Indicates whether enable the trace functionality, which will be deprecated since api version 2020-11-01-preview.
     * Please leverage appInsightsInstrumentationKey to indicate if monitoringSettings enabled or not
     */
    private Boolean traceEnabled;

    /*
     * Target application insight instrumentation key, null or whitespace include empty will disable monitoringSettings
     */
    private String appInsightsInstrumentationKey;

    /*
     * Indicates the sampling rate of application insight agent, should be in range [0.0, 100.0]
     */
    private Double appInsightsSamplingRate;

    /*
     * Indicates the versions of application insight agent
     */
    private ApplicationInsightsAgentVersions appInsightsAgentVersions;

    /**
     * Creates an instance of MonitoringSettingProperties class.
     */
    public MonitoringSettingProperties() {
    }

    /**
     * Get the provisioningState property: State of the Monitoring Setting.
     * 
     * @return the provisioningState value.
     */
    public MonitoringSettingState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the error property: Error when apply Monitoring Setting changes.
     * 
     * @return the error value.
     */
    public Error error() {
        return this.error;
    }

    /**
     * Set the error property: Error when apply Monitoring Setting changes.
     * 
     * @param error the error value to set.
     * @return the MonitoringSettingProperties object itself.
     */
    public MonitoringSettingProperties withError(Error error) {
        this.error = error;
        return this;
    }

    /**
     * Get the traceEnabled property: Indicates whether enable the trace functionality, which will be deprecated since
     * api version 2020-11-01-preview. Please leverage appInsightsInstrumentationKey to indicate if monitoringSettings
     * enabled or not.
     * 
     * @return the traceEnabled value.
     */
    public Boolean traceEnabled() {
        return this.traceEnabled;
    }

    /**
     * Set the traceEnabled property: Indicates whether enable the trace functionality, which will be deprecated since
     * api version 2020-11-01-preview. Please leverage appInsightsInstrumentationKey to indicate if monitoringSettings
     * enabled or not.
     * 
     * @param traceEnabled the traceEnabled value to set.
     * @return the MonitoringSettingProperties object itself.
     */
    public MonitoringSettingProperties withTraceEnabled(Boolean traceEnabled) {
        this.traceEnabled = traceEnabled;
        return this;
    }

    /**
     * Get the appInsightsInstrumentationKey property: Target application insight instrumentation key, null or
     * whitespace include empty will disable monitoringSettings.
     * 
     * @return the appInsightsInstrumentationKey value.
     */
    public String appInsightsInstrumentationKey() {
        return this.appInsightsInstrumentationKey;
    }

    /**
     * Set the appInsightsInstrumentationKey property: Target application insight instrumentation key, null or
     * whitespace include empty will disable monitoringSettings.
     * 
     * @param appInsightsInstrumentationKey the appInsightsInstrumentationKey value to set.
     * @return the MonitoringSettingProperties object itself.
     */
    public MonitoringSettingProperties withAppInsightsInstrumentationKey(String appInsightsInstrumentationKey) {
        this.appInsightsInstrumentationKey = appInsightsInstrumentationKey;
        return this;
    }

    /**
     * Get the appInsightsSamplingRate property: Indicates the sampling rate of application insight agent, should be in
     * range [0.0, 100.0].
     * 
     * @return the appInsightsSamplingRate value.
     */
    public Double appInsightsSamplingRate() {
        return this.appInsightsSamplingRate;
    }

    /**
     * Set the appInsightsSamplingRate property: Indicates the sampling rate of application insight agent, should be in
     * range [0.0, 100.0].
     * 
     * @param appInsightsSamplingRate the appInsightsSamplingRate value to set.
     * @return the MonitoringSettingProperties object itself.
     */
    public MonitoringSettingProperties withAppInsightsSamplingRate(Double appInsightsSamplingRate) {
        this.appInsightsSamplingRate = appInsightsSamplingRate;
        return this;
    }

    /**
     * Get the appInsightsAgentVersions property: Indicates the versions of application insight agent.
     * 
     * @return the appInsightsAgentVersions value.
     */
    public ApplicationInsightsAgentVersions appInsightsAgentVersions() {
        return this.appInsightsAgentVersions;
    }

    /**
     * Set the appInsightsAgentVersions property: Indicates the versions of application insight agent.
     * 
     * @param appInsightsAgentVersions the appInsightsAgentVersions value to set.
     * @return the MonitoringSettingProperties object itself.
     */
    public MonitoringSettingProperties
        withAppInsightsAgentVersions(ApplicationInsightsAgentVersions appInsightsAgentVersions) {
        this.appInsightsAgentVersions = appInsightsAgentVersions;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (error() != null) {
            error().validate();
        }
        if (appInsightsAgentVersions() != null) {
            appInsightsAgentVersions().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("error", this.error);
        jsonWriter.writeBooleanField("traceEnabled", this.traceEnabled);
        jsonWriter.writeStringField("appInsightsInstrumentationKey", this.appInsightsInstrumentationKey);
        jsonWriter.writeNumberField("appInsightsSamplingRate", this.appInsightsSamplingRate);
        jsonWriter.writeJsonField("appInsightsAgentVersions", this.appInsightsAgentVersions);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MonitoringSettingProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MonitoringSettingProperties if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MonitoringSettingProperties.
     */
    public static MonitoringSettingProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MonitoringSettingProperties deserializedMonitoringSettingProperties = new MonitoringSettingProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("provisioningState".equals(fieldName)) {
                    deserializedMonitoringSettingProperties.provisioningState
                        = MonitoringSettingState.fromString(reader.getString());
                } else if ("error".equals(fieldName)) {
                    deserializedMonitoringSettingProperties.error = Error.fromJson(reader);
                } else if ("traceEnabled".equals(fieldName)) {
                    deserializedMonitoringSettingProperties.traceEnabled = reader.getNullable(JsonReader::getBoolean);
                } else if ("appInsightsInstrumentationKey".equals(fieldName)) {
                    deserializedMonitoringSettingProperties.appInsightsInstrumentationKey = reader.getString();
                } else if ("appInsightsSamplingRate".equals(fieldName)) {
                    deserializedMonitoringSettingProperties.appInsightsSamplingRate
                        = reader.getNullable(JsonReader::getDouble);
                } else if ("appInsightsAgentVersions".equals(fieldName)) {
                    deserializedMonitoringSettingProperties.appInsightsAgentVersions
                        = ApplicationInsightsAgentVersions.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMonitoringSettingProperties;
        });
    }
}
