// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Regenerate test key request payload.
 */
@Fluent
public final class RegenerateTestKeyRequestPayload implements JsonSerializable<RegenerateTestKeyRequestPayload> {
    /*
     * Type of the test key
     */
    private TestKeyType keyType;

    /**
     * Creates an instance of RegenerateTestKeyRequestPayload class.
     */
    public RegenerateTestKeyRequestPayload() {
    }

    /**
     * Get the keyType property: Type of the test key.
     * 
     * @return the keyType value.
     */
    public TestKeyType keyType() {
        return this.keyType;
    }

    /**
     * Set the keyType property: Type of the test key.
     * 
     * @param keyType the keyType value to set.
     * @return the RegenerateTestKeyRequestPayload object itself.
     */
    public RegenerateTestKeyRequestPayload withKeyType(TestKeyType keyType) {
        this.keyType = keyType;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (keyType() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property keyType in model RegenerateTestKeyRequestPayload"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(RegenerateTestKeyRequestPayload.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("keyType", this.keyType == null ? null : this.keyType.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RegenerateTestKeyRequestPayload from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RegenerateTestKeyRequestPayload if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RegenerateTestKeyRequestPayload.
     */
    public static RegenerateTestKeyRequestPayload fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RegenerateTestKeyRequestPayload deserializedRegenerateTestKeyRequestPayload
                = new RegenerateTestKeyRequestPayload();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("keyType".equals(fieldName)) {
                    deserializedRegenerateTestKeyRequestPayload.keyType = TestKeyType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRegenerateTestKeyRequestPayload;
        });
    }
}
