// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Object that includes an array of Azure Spring Apps SKU and a possible link for next set.
 */
@Fluent
public final class ResourceSkuCollection implements JsonSerializable<ResourceSkuCollection> {
    /*
     * Collection of resource SKU
     */
    private List<ResourceSku> value;

    /*
     * URL client should use to fetch the next page (per server side paging).
     * It's null for now, added for future use.
     */
    private String nextLink;

    /**
     * Creates an instance of ResourceSkuCollection class.
     */
    public ResourceSkuCollection() {
    }

    /**
     * Get the value property: Collection of resource SKU.
     * 
     * @return the value value.
     */
    public List<ResourceSku> value() {
        return this.value;
    }

    /**
     * Set the value property: Collection of resource SKU.
     * 
     * @param value the value value to set.
     * @return the ResourceSkuCollection object itself.
     */
    public ResourceSkuCollection withValue(List<ResourceSku> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: URL client should use to fetch the next page (per server side paging).
     * It's null for now, added for future use.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: URL client should use to fetch the next page (per server side paging).
     * It's null for now, added for future use.
     * 
     * @param nextLink the nextLink value to set.
     * @return the ResourceSkuCollection object itself.
     */
    public ResourceSkuCollection withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResourceSkuCollection from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResourceSkuCollection if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ResourceSkuCollection.
     */
    public static ResourceSkuCollection fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ResourceSkuCollection deserializedResourceSkuCollection = new ResourceSkuCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<ResourceSku> value = reader.readArray(reader1 -> ResourceSku.fromJson(reader1));
                    deserializedResourceSkuCollection.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedResourceSkuCollection.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedResourceSkuCollection;
        });
    }
}
