// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Restrictions where the SKU cannot be used.
 */
@Fluent
public final class ResourceSkuRestrictions implements JsonSerializable<ResourceSkuRestrictions> {
    /*
     * Gets the type of restrictions. Possible values include: 'Location', 'Zone'
     */
    private ResourceSkuRestrictionsType type;

    /*
     * Gets the value of restrictions. If the restriction type is set to
     * location. This would be different locations where the SKU is restricted.
     */
    private List<String> values;

    /*
     * Gets the information about the restriction where the SKU cannot be used.
     */
    private ResourceSkuRestrictionInfo restrictionInfo;

    /*
     * Gets the reason for restriction. Possible values include: 'QuotaId', 'NotAvailableForSubscription'
     */
    private ResourceSkuRestrictionsReasonCode reasonCode;

    /**
     * Creates an instance of ResourceSkuRestrictions class.
     */
    public ResourceSkuRestrictions() {
    }

    /**
     * Get the type property: Gets the type of restrictions. Possible values include: 'Location', 'Zone'.
     * 
     * @return the type value.
     */
    public ResourceSkuRestrictionsType type() {
        return this.type;
    }

    /**
     * Set the type property: Gets the type of restrictions. Possible values include: 'Location', 'Zone'.
     * 
     * @param type the type value to set.
     * @return the ResourceSkuRestrictions object itself.
     */
    public ResourceSkuRestrictions withType(ResourceSkuRestrictionsType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the values property: Gets the value of restrictions. If the restriction type is set to
     * location. This would be different locations where the SKU is restricted.
     * 
     * @return the values value.
     */
    public List<String> values() {
        return this.values;
    }

    /**
     * Set the values property: Gets the value of restrictions. If the restriction type is set to
     * location. This would be different locations where the SKU is restricted.
     * 
     * @param values the values value to set.
     * @return the ResourceSkuRestrictions object itself.
     */
    public ResourceSkuRestrictions withValues(List<String> values) {
        this.values = values;
        return this;
    }

    /**
     * Get the restrictionInfo property: Gets the information about the restriction where the SKU cannot be used.
     * 
     * @return the restrictionInfo value.
     */
    public ResourceSkuRestrictionInfo restrictionInfo() {
        return this.restrictionInfo;
    }

    /**
     * Set the restrictionInfo property: Gets the information about the restriction where the SKU cannot be used.
     * 
     * @param restrictionInfo the restrictionInfo value to set.
     * @return the ResourceSkuRestrictions object itself.
     */
    public ResourceSkuRestrictions withRestrictionInfo(ResourceSkuRestrictionInfo restrictionInfo) {
        this.restrictionInfo = restrictionInfo;
        return this;
    }

    /**
     * Get the reasonCode property: Gets the reason for restriction. Possible values include: 'QuotaId',
     * 'NotAvailableForSubscription'.
     * 
     * @return the reasonCode value.
     */
    public ResourceSkuRestrictionsReasonCode reasonCode() {
        return this.reasonCode;
    }

    /**
     * Set the reasonCode property: Gets the reason for restriction. Possible values include: 'QuotaId',
     * 'NotAvailableForSubscription'.
     * 
     * @param reasonCode the reasonCode value to set.
     * @return the ResourceSkuRestrictions object itself.
     */
    public ResourceSkuRestrictions withReasonCode(ResourceSkuRestrictionsReasonCode reasonCode) {
        this.reasonCode = reasonCode;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (restrictionInfo() != null) {
            restrictionInfo().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeArrayField("values", this.values, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("restrictionInfo", this.restrictionInfo);
        jsonWriter.writeStringField("reasonCode", this.reasonCode == null ? null : this.reasonCode.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResourceSkuRestrictions from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResourceSkuRestrictions if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ResourceSkuRestrictions.
     */
    public static ResourceSkuRestrictions fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ResourceSkuRestrictions deserializedResourceSkuRestrictions = new ResourceSkuRestrictions();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("type".equals(fieldName)) {
                    deserializedResourceSkuRestrictions.type
                        = ResourceSkuRestrictionsType.fromString(reader.getString());
                } else if ("values".equals(fieldName)) {
                    List<String> values = reader.readArray(reader1 -> reader1.getString());
                    deserializedResourceSkuRestrictions.values = values;
                } else if ("restrictionInfo".equals(fieldName)) {
                    deserializedResourceSkuRestrictions.restrictionInfo = ResourceSkuRestrictionInfo.fromJson(reader);
                } else if ("reasonCode".equals(fieldName)) {
                    deserializedResourceSkuRestrictions.reasonCode
                        = ResourceSkuRestrictionsReasonCode.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedResourceSkuRestrictions;
        });
    }
}
