/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appplatform.models.ResourceSku;
import java.io.IOException;
import java.util.List;

public final class ResourceSkuCollection
implements JsonSerializable<ResourceSkuCollection> {
    private List<ResourceSku> value;
    private String nextLink;

    public List<ResourceSku> value() {
        return this.value;
    }

    public ResourceSkuCollection withValue(List<ResourceSku> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public ResourceSkuCollection withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static ResourceSkuCollection fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceSkuCollection)jsonReader.readObject(reader -> {
            ResourceSkuCollection deserializedResourceSkuCollection = new ResourceSkuCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedResourceSkuCollection.value = value = reader.readArray(reader1 -> ResourceSku.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedResourceSkuCollection.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceSkuCollection;
        });
    }
}

