// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appplatform.models.AppResourceProperties;
import com.azure.resourcemanager.appplatform.models.ManagedIdentityProperties;
import java.io.IOException;

/**
 * App resource payload.
 */
@Fluent
public final class AppResourceInner extends ProxyResource {
    /*
     * Properties of the App resource
     */
    private AppResourceProperties properties;

    /*
     * The Managed Identity type of the app resource
     */
    private ManagedIdentityProperties identity;

    /*
     * The GEO location of the application, always the same with its parent resource
     */
    private String location;

    /*
     * Metadata pertaining to creation and last modification of the resource.
     */
    private SystemData systemData;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * The type of the resource.
     */
    private String type;

    /**
     * Creates an instance of AppResourceInner class.
     */
    public AppResourceInner() {
    }

    /**
     * Get the properties property: Properties of the App resource.
     * 
     * @return the properties value.
     */
    public AppResourceProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties property: Properties of the App resource.
     * 
     * @param properties the properties value to set.
     * @return the AppResourceInner object itself.
     */
    public AppResourceInner withProperties(AppResourceProperties properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Get the identity property: The Managed Identity type of the app resource.
     * 
     * @return the identity value.
     */
    public ManagedIdentityProperties identity() {
        return this.identity;
    }

    /**
     * Set the identity property: The Managed Identity type of the app resource.
     * 
     * @param identity the identity value to set.
     * @return the AppResourceInner object itself.
     */
    public AppResourceInner withIdentity(ManagedIdentityProperties identity) {
        this.identity = identity;
        return this;
    }

    /**
     * Get the location property: The GEO location of the application, always the same with its parent resource.
     * 
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Set the location property: The GEO location of the application, always the same with its parent resource.
     * 
     * @param location the location value to set.
     * @return the AppResourceInner object itself.
     */
    public AppResourceInner withLocation(String location) {
        this.location = location;
        return this;
    }

    /**
     * Get the systemData property: Metadata pertaining to creation and last modification of the resource.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (properties() != null) {
            properties().validate();
        }
        if (identity() != null) {
            identity().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.properties);
        jsonWriter.writeJsonField("identity", this.identity);
        jsonWriter.writeStringField("location", this.location);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AppResourceInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AppResourceInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AppResourceInner.
     */
    public static AppResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AppResourceInner deserializedAppResourceInner = new AppResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedAppResourceInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedAppResourceInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedAppResourceInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedAppResourceInner.properties = AppResourceProperties.fromJson(reader);
                } else if ("identity".equals(fieldName)) {
                    deserializedAppResourceInner.identity = ManagedIdentityProperties.fromJson(reader);
                } else if ("location".equals(fieldName)) {
                    deserializedAppResourceInner.location = reader.getString();
                } else if ("systemData".equals(fieldName)) {
                    deserializedAppResourceInner.systemData = SystemData.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAppResourceInner;
        });
    }
}
