// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Auth setting for public url.
 */
@Fluent
public final class AcceleratorPublicSetting extends AcceleratorAuthSetting {
    /*
     * The type of the auth setting.
     */
    private String authType = "Public";

    /*
     * Resource Id of CA certificate for https URL of Git repository.
     */
    private String caCertResourceId;

    /**
     * Creates an instance of AcceleratorPublicSetting class.
     */
    public AcceleratorPublicSetting() {
    }

    /**
     * Get the authType property: The type of the auth setting.
     * 
     * @return the authType value.
     */
    @Override
    public String authType() {
        return this.authType;
    }

    /**
     * Get the caCertResourceId property: Resource Id of CA certificate for https URL of Git repository.
     * 
     * @return the caCertResourceId value.
     */
    public String caCertResourceId() {
        return this.caCertResourceId;
    }

    /**
     * Set the caCertResourceId property: Resource Id of CA certificate for https URL of Git repository.
     * 
     * @param caCertResourceId the caCertResourceId value to set.
     * @return the AcceleratorPublicSetting object itself.
     */
    public AcceleratorPublicSetting withCaCertResourceId(String caCertResourceId) {
        this.caCertResourceId = caCertResourceId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("authType", this.authType);
        jsonWriter.writeStringField("caCertResourceId", this.caCertResourceId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AcceleratorPublicSetting from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AcceleratorPublicSetting if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AcceleratorPublicSetting.
     */
    public static AcceleratorPublicSetting fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AcceleratorPublicSetting deserializedAcceleratorPublicSetting = new AcceleratorPublicSetting();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("authType".equals(fieldName)) {
                    deserializedAcceleratorPublicSetting.authType = reader.getString();
                } else if ("caCertResourceId".equals(fieldName)) {
                    deserializedAcceleratorPublicSetting.caCertResourceId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAcceleratorPublicSetting;
        });
    }
}
