// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Collection of instances belong to the API portal.
 */
@Immutable
public final class ApiPortalInstance implements JsonSerializable<ApiPortalInstance> {
    /*
     * Name of the API portal instance
     */
    private String name;

    /*
     * Status of the API portal instance
     */
    private String status;

    /**
     * Creates an instance of ApiPortalInstance class.
     */
    public ApiPortalInstance() {
    }

    /**
     * Get the name property: Name of the API portal instance.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the status property: Status of the API portal instance.
     * 
     * @return the status value.
     */
    public String status() {
        return this.status;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApiPortalInstance from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApiPortalInstance if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApiPortalInstance.
     */
    public static ApiPortalInstance fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApiPortalInstance deserializedApiPortalInstance = new ApiPortalInstance();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedApiPortalInstance.name = reader.getString();
                } else if ("status".equals(fieldName)) {
                    deserializedApiPortalInstance.status = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApiPortalInstance;
        });
    }
}
