// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The settings of config server.
 */
@Fluent
public final class ConfigServerSettings implements JsonSerializable<ConfigServerSettings> {
    /*
     * Property of git environment.
     */
    private ConfigServerGitProperty gitProperty;

    /**
     * Creates an instance of ConfigServerSettings class.
     */
    public ConfigServerSettings() {
    }

    /**
     * Get the gitProperty property: Property of git environment.
     * 
     * @return the gitProperty value.
     */
    public ConfigServerGitProperty gitProperty() {
        return this.gitProperty;
    }

    /**
     * Set the gitProperty property: Property of git environment.
     * 
     * @param gitProperty the gitProperty value to set.
     * @return the ConfigServerSettings object itself.
     */
    public ConfigServerSettings withGitProperty(ConfigServerGitProperty gitProperty) {
        this.gitProperty = gitProperty;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (gitProperty() != null) {
            gitProperty().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("gitProperty", this.gitProperty);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ConfigServerSettings from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ConfigServerSettings if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ConfigServerSettings.
     */
    public static ConfigServerSettings fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ConfigServerSettings deserializedConfigServerSettings = new ConfigServerSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("gitProperty".equals(fieldName)) {
                    deserializedConfigServerSettings.gitProperty = ConfigServerGitProperty.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedConfigServerSettings;
        });
    }
}
