// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * API metadata property for Spring Cloud Gateway.
 */
@Fluent
public final class GatewayApiMetadataProperties implements JsonSerializable<GatewayApiMetadataProperties> {
    /*
     * Title describing the context of the APIs available on the Gateway instance (default: `Spring Cloud Gateway for
     * K8S`)
     */
    private String title;

    /*
     * Detailed description of the APIs available on the Gateway instance (default: `Generated OpenAPI 3 document that
     * describes the API routes configured.`)
     */
    private String description;

    /*
     * Location of additional documentation for the APIs available on the Gateway instance
     */
    private String documentation;

    /*
     * Version of APIs available on this Gateway instance (default: `unspecified`).
     */
    private String version;

    /*
     * Base URL that API consumers will use to access APIs on the Gateway instance.
     */
    private String serverUrl;

    /**
     * Creates an instance of GatewayApiMetadataProperties class.
     */
    public GatewayApiMetadataProperties() {
    }

    /**
     * Get the title property: Title describing the context of the APIs available on the Gateway instance (default:
     * `Spring Cloud Gateway for K8S`).
     * 
     * @return the title value.
     */
    public String title() {
        return this.title;
    }

    /**
     * Set the title property: Title describing the context of the APIs available on the Gateway instance (default:
     * `Spring Cloud Gateway for K8S`).
     * 
     * @param title the title value to set.
     * @return the GatewayApiMetadataProperties object itself.
     */
    public GatewayApiMetadataProperties withTitle(String title) {
        this.title = title;
        return this;
    }

    /**
     * Get the description property: Detailed description of the APIs available on the Gateway instance (default:
     * `Generated OpenAPI 3 document that describes the API routes configured.`).
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: Detailed description of the APIs available on the Gateway instance (default:
     * `Generated OpenAPI 3 document that describes the API routes configured.`).
     * 
     * @param description the description value to set.
     * @return the GatewayApiMetadataProperties object itself.
     */
    public GatewayApiMetadataProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the documentation property: Location of additional documentation for the APIs available on the Gateway
     * instance.
     * 
     * @return the documentation value.
     */
    public String documentation() {
        return this.documentation;
    }

    /**
     * Set the documentation property: Location of additional documentation for the APIs available on the Gateway
     * instance.
     * 
     * @param documentation the documentation value to set.
     * @return the GatewayApiMetadataProperties object itself.
     */
    public GatewayApiMetadataProperties withDocumentation(String documentation) {
        this.documentation = documentation;
        return this;
    }

    /**
     * Get the version property: Version of APIs available on this Gateway instance (default: `unspecified`).
     * 
     * @return the version value.
     */
    public String version() {
        return this.version;
    }

    /**
     * Set the version property: Version of APIs available on this Gateway instance (default: `unspecified`).
     * 
     * @param version the version value to set.
     * @return the GatewayApiMetadataProperties object itself.
     */
    public GatewayApiMetadataProperties withVersion(String version) {
        this.version = version;
        return this;
    }

    /**
     * Get the serverUrl property: Base URL that API consumers will use to access APIs on the Gateway instance.
     * 
     * @return the serverUrl value.
     */
    public String serverUrl() {
        return this.serverUrl;
    }

    /**
     * Set the serverUrl property: Base URL that API consumers will use to access APIs on the Gateway instance.
     * 
     * @param serverUrl the serverUrl value to set.
     * @return the GatewayApiMetadataProperties object itself.
     */
    public GatewayApiMetadataProperties withServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("title", this.title);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("documentation", this.documentation);
        jsonWriter.writeStringField("version", this.version);
        jsonWriter.writeStringField("serverUrl", this.serverUrl);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GatewayApiMetadataProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GatewayApiMetadataProperties if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the GatewayApiMetadataProperties.
     */
    public static GatewayApiMetadataProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GatewayApiMetadataProperties deserializedGatewayApiMetadataProperties = new GatewayApiMetadataProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("title".equals(fieldName)) {
                    deserializedGatewayApiMetadataProperties.title = reader.getString();
                } else if ("description".equals(fieldName)) {
                    deserializedGatewayApiMetadataProperties.description = reader.getString();
                } else if ("documentation".equals(fieldName)) {
                    deserializedGatewayApiMetadataProperties.documentation = reader.getString();
                } else if ("version".equals(fieldName)) {
                    deserializedGatewayApiMetadataProperties.version = reader.getString();
                } else if ("serverUrl".equals(fieldName)) {
                    deserializedGatewayApiMetadataProperties.serverUrl = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGatewayApiMetadataProperties;
        });
    }
}
