// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Resource upload definition payload.
 */
@Fluent
public final class ResourceUploadDefinition implements JsonSerializable<ResourceUploadDefinition> {
    /*
     * Source relative path
     */
    private String relativePath;

    /*
     * Upload URL
     */
    private String uploadUrl;

    /**
     * Creates an instance of ResourceUploadDefinition class.
     */
    public ResourceUploadDefinition() {
    }

    /**
     * Get the relativePath property: Source relative path.
     * 
     * @return the relativePath value.
     */
    public String relativePath() {
        return this.relativePath;
    }

    /**
     * Set the relativePath property: Source relative path.
     * 
     * @param relativePath the relativePath value to set.
     * @return the ResourceUploadDefinition object itself.
     */
    public ResourceUploadDefinition withRelativePath(String relativePath) {
        this.relativePath = relativePath;
        return this;
    }

    /**
     * Get the uploadUrl property: Upload URL.
     * 
     * @return the uploadUrl value.
     */
    public String uploadUrl() {
        return this.uploadUrl;
    }

    /**
     * Set the uploadUrl property: Upload URL.
     * 
     * @param uploadUrl the uploadUrl value to set.
     * @return the ResourceUploadDefinition object itself.
     */
    public ResourceUploadDefinition withUploadUrl(String uploadUrl) {
        this.uploadUrl = uploadUrl;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("relativePath", this.relativePath);
        jsonWriter.writeStringField("uploadUrl", this.uploadUrl);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResourceUploadDefinition from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResourceUploadDefinition if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ResourceUploadDefinition.
     */
    public static ResourceUploadDefinition fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ResourceUploadDefinition deserializedResourceUploadDefinition = new ResourceUploadDefinition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("relativePath".equals(fieldName)) {
                    deserializedResourceUploadDefinition.relativePath = reader.getString();
                } else if ("uploadUrl".equals(fieldName)) {
                    deserializedResourceUploadDefinition.uploadUrl = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedResourceUploadDefinition;
        });
    }
}
