/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appplatform.models.ServiceRegistryInstance;
import com.azure.resourcemanager.appplatform.models.ServiceRegistryProvisioningState;
import com.azure.resourcemanager.appplatform.models.ServiceRegistryResourceRequests;
import java.io.IOException;
import java.util.List;

public final class ServiceRegistryProperties
implements JsonSerializable<ServiceRegistryProperties> {
    private ServiceRegistryProvisioningState provisioningState;
    private ServiceRegistryResourceRequests resourceRequests;
    private List<ServiceRegistryInstance> instances;

    public ServiceRegistryProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public ServiceRegistryResourceRequests resourceRequests() {
        return this.resourceRequests;
    }

    public List<ServiceRegistryInstance> instances() {
        return this.instances;
    }

    public void validate() {
        if (this.resourceRequests() != null) {
            this.resourceRequests().validate();
        }
        if (this.instances() != null) {
            this.instances().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static ServiceRegistryProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ServiceRegistryProperties)jsonReader.readObject(reader -> {
            ServiceRegistryProperties deserializedServiceRegistryProperties = new ServiceRegistryProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedServiceRegistryProperties.provisioningState = ServiceRegistryProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("resourceRequests".equals(fieldName)) {
                    deserializedServiceRegistryProperties.resourceRequests = ServiceRegistryResourceRequests.fromJson(reader);
                    continue;
                }
                if ("instances".equals(fieldName)) {
                    List instances;
                    deserializedServiceRegistryProperties.instances = instances = reader.readArray(reader1 -> ServiceRegistryInstance.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedServiceRegistryProperties;
        });
    }
}

